import React from "react";
import { connect } from "react-redux";
import PropTypes from "prop-types";

import { Grid, Row, Col } from "react-bootstrap";

import ImagesPanel from "./ImagesPanel";
import RegionsPanel from "./RegionsPanel";
import BannersPanel from "./BannersPanel";
import ButtonsPanel from "./ButtonsPanel";
import AdGroupsPanel from "./AdGroupsPanel";
import CampaignPanel from "./CampaignPanel";
import ClientsPanel from "./ClientsPanel";
import ModalContainer from "../ModalContainer";

import "./index.scss";

import { upload, hideSavingInfo } from "../actions/Upload";
import { preview, catalog } from "../actions";
import { ValidationErrorTypes } from "../actions/validator";

class UploadingPanel extends React.Component {
    getFormattedSavingInfo(client) {
        return (
            <div>
                Имя кампании: {client.campaign.name}
                <br />
                Клиент: {client.name}
                <br />
                Статус: {client.savingStatus && client.savingStatus.message}
            </div>
        );
    }

    parse_validation(validation, errors) {
        switch (validation.error) {
            case ValidationErrorTypes.MULTIPLE_ERRORS:
                validation.errors.forEach((error) => this.parse_validation(error, errors));
                break;
            case ValidationErrorTypes.ONE_OR_MORE_ERRORS:
                for (let key in validation.invalid) {
                    if (validation.invalid.hasOwnProperty(key)) {
                        this.parse_validation(validation.invalid[key], errors);
                    }
                }
                break;
            default:
                errors.push(validation.error_message);
        }
    }

    renderValidation(validation) {
        if (validation === null) {
            return null;
        }
        const errors = [];
        this.parse_validation(validation, errors);
        let message = "";
        errors.forEach((error) => (message += error + "\n"));
        if (message !== "") {
            return <div className="FieldLayout DisplayLinebreak ErrorsBlock">{message}</div>;
        } else {
            return null;
        }
    }

    renderUpload() {
        const { client, clients, api, onHideSavingInfo, onPreview, onUpload, onCatalog } = this.props;
        return (
            <Grid fluid={true}>
                <Row>
                    <Col md={9}>
                        <ClientsPanel selectedClientId={client.id} clients={clients} />
                    </Col>
                    <Col md={3}>
                        <ButtonsPanel
                            onUpload={() => onUpload(client)}
                            onPreview={() => onPreview(client)}
                            onCatalog={() => onCatalog(client)}
                        />
                        <ModalContainer
                            visible={client.savingStatus && client.savingStatus.visible}
                            onClose={() => onHideSavingInfo(client)}
                        >
                            {this.getFormattedSavingInfo(client)}
                        </ModalContainer>
                    </Col>
                </Row>
                <Row>
                    <Col md={4}>
                        <div className="BlockLayout">
                            {this.renderValidation(client.validation)}
                            <CampaignPanel clientId={client.id} />
                            <RegionsPanel clientId={client.id} />
                            <ImagesPanel clientId={client.id} api={api} />
                        </div>
                    </Col>
                    <Col md={4}>
                        <div className="BlockLayout">
                            <AdGroupsPanel clientId={client.id} />
                        </div>
                    </Col>
                    <Col md={4}>
                        <div className="BlockLayout">
                            <BannersPanel clientId={client.id} />
                        </div>
                    </Col>
                </Row>
            </Grid>
        );
    }

    render() {
        return <div>{this.renderUpload()}</div>;
    }
}

function mapStateToProps(state, ownProps) {
    return {};
}

function mapDispatchToProps(dispatch, ownProps) {
    return {
        onPreview: (client) => dispatch(preview(ownProps.api, client)),
        onUpload: (client) => dispatch(upload(ownProps.api, client)),
        onCatalog: (client) => dispatch(catalog(ownProps.api, client.id)),
        onHideSavingInfo: (client) => dispatch(hideSavingInfo(client.id)),
    };
}

UploadingPanel.propTypes = {
    api: PropTypes.object.isRequired,
    client: PropTypes.shape({}).isRequired,
    clients: PropTypes.arrayOf(PropTypes.shape({})).isRequired,
};

export default connect(mapStateToProps, mapDispatchToProps)(UploadingPanel);
