// API

export const RECEIVE_PREVIEW_CAMPAIGNS = "RECEIVE_PREVIEW_CAMPAIGNS";
export const RECEIVE_PREVIEW_ADGROUPS = "RECEIVE_PREVIEW_ADGROUPS";
export const RECEIVE_PREVIEW_PHRASES = "RECEIVE_PREVIEW_PHRASES";
export const RECEIVE_PREVIEW_BANNERS = "RECEIVE_PREVIEW_BANNERS";

// Selectors

export const SELECT_PREVIEW_ADGROUP = "SELECT_PREVIEW_ADGROUP";
export const SELECT_PREVIEW_CAMPAIGN = "SELECT_PREVIEW_CAMPAIGN";

// View

export const LOADING_PREVIEW_PANEL_DONE = "LOADING_PREVIEW_PANEL_DONE";

export { initializePreviewPanelIfNeeded, previewAdGroup, previewCampaign };

// ========== API ==========

// == Initialization ==

function initializePreviewPanelIfNeeded(api, clientId, templateId) {
    return (dispatch, getState) => {
        if (getState().previewPanel.isLoaded === false) {
            dispatch(fetchCampaigns(api, clientId, templateId)).then((_) => dispatch(markPreviewPanelIsLoaded()));
        }
    };
}

// == Campaigns ==

function fetchCampaigns(api, clientId, templateId) {
    return (dispatch) => {
        return api.getCampaigns(clientId, templateId).then((campaigns) => {
            if (campaigns.length > 0) {
                const campaignId = campaigns[0].id;
                dispatch(receiveCampaigns(campaigns, campaignId));
                return dispatch(fetchAdGroups(api, clientId, templateId, campaignId));
            }
        });
    };
}

function receiveCampaigns(campaigns, activeId) {
    return {
        type: RECEIVE_PREVIEW_CAMPAIGNS,
        campaigns,
        activeId,
    };
}

// == AdGroups ==

function fetchAdGroups(api, clientId, templateId, campaignId) {
    return (dispatch) =>
        api.getAdGroups(clientId, templateId, campaignId).then((adGroups) => {
            if (adGroups.length > 0) {
                const adGroupId = adGroups[0].id;
                dispatch(receiveAdGroups(adGroups, adGroupId));
                dispatch(fetchBanners(api, clientId, templateId, campaignId, adGroupId));
                dispatch(fetchPhrases(api, clientId, templateId, campaignId, adGroupId));
            }
        });
}

function receiveAdGroups(adGroups, activeId) {
    return {
        type: RECEIVE_PREVIEW_ADGROUPS,
        adGroups,
        activeId,
    };
}

// == Banners ==

function fetchBanners(api, clientId, templateId, campaignId, adGroupId) {
    return (dispatch) =>
        api
            .getBanners(clientId, templateId, campaignId, adGroupId)
            .then((banners) => dispatch(receiveBanners(banners)));
}

function receiveBanners(banners) {
    return {
        type: RECEIVE_PREVIEW_BANNERS,
        banners,
    };
}

// == Phrases ==

function fetchPhrases(api, clientId, templateId, campaignId, adGroupId) {
    return (dispatch) =>
        api
            .getPhrases(clientId, templateId, campaignId, adGroupId)
            .then((phrases) => dispatch(receivePhrases(phrases)));
}

function receivePhrases(phrases) {
    return {
        type: RECEIVE_PREVIEW_PHRASES,
        phrases,
    };
}

// ========== Selectors ==========

// == Campaigns ==

function previewCampaign(api, clientId, templateId, campaignId) {
    return (dispatch) => {
        dispatch(fetchAdGroups(api, clientId, templateId, campaignId));
        dispatch(selectPreviewCampaign(campaignId));
    };
}

function selectPreviewCampaign(campaignId) {
    return {
        type: SELECT_PREVIEW_CAMPAIGN,
        campaignId,
    };
}

// == AdGroups ==

function previewAdGroup(api, clientId, templateId, campaignId, adGroupId) {
    return (dispatch) => {
        dispatch(fetchBanners(api, clientId, templateId, campaignId, adGroupId));
        dispatch(fetchPhrases(api, clientId, templateId, campaignId, adGroupId));
        dispatch(selectPreviewAdGroup(adGroupId));
    };
}

function selectPreviewAdGroup(adGroupId) {
    return {
        type: SELECT_PREVIEW_ADGROUP,
        adGroupId,
    };
}

// ========== View ==========

function markPreviewPanelIsLoaded() {
    return {
        type: LOADING_PREVIEW_PANEL_DONE,
    };
}
