import React, { useEffect } from "react";
import AppHeader from "AppHeader";
import { connect, useDispatch } from "react-redux";
import Loading from "@lib/components/loading";
import Failable from "utils/Failable";
import { fetchRoles, getApi, updateNow } from "actions";
import { getAccessState, getApiState } from "selectors";

import Header from "@lib/components/header";
import Body from "@lib/components/body";
import Footer from "@lib/components/footer";

const Layout = connect((state) => ({
    api: getApiState(state),
    access: getAccessState(state),
    failed: state.base.failed,
    message: state.base.message,
}))((props) => {
    const { api, access, failed, message } = props;

    const dispatch = useDispatch();

    useEffect(() => {
        dispatch(getApi(api));
        dispatch(fetchRoles(api));

        setInterval(() => dispatch(updateNow(Date.now())), 10000);
    }, []);

    return (
        <div className="application">
            <Header>
                <AppHeader key="header" className="header" />
            </Header>
            <Body>
                <Failable failed={failed} errorMessage={message}>
                    <Loading loaded={access != null}>{props.children}</Loading>
                </Failable>
            </Body>
            <Footer key="footer" />
        </div>
    );
});

export default Layout;
