import React from "react";
import { connect, useDispatch } from "react-redux";
import { useTranslation } from "react-i18next";
import { Modal } from "@lib/components/lego";
import { hideModal } from "actions";
import { getSelectedAudienceState, getVisibleModalState } from "./selectors";
import AudienceInfoModalBody from "./AudienceInfoModalBody";

import "./AudienceInfoModal.scss";
import LabModalHeader from "../utils/LabModalHeader";

const AudienceInfoModal = connect((state) => ({
    visible: getVisibleModalState(state, "AudienceInfoModal"),
    audience: getSelectedAudienceState(state),
}))((props) => {
    const { visible, audience } = props;
    const dispatch = useDispatch();
    const { t } = useTranslation("audience");

    const onClose = () => dispatch(hideModal("AudienceInfoModal"));

    return (
        audience && (
            <Modal theme="normal" visible={visible} onClose={onClose}>
                <div className="AudienceInfoModal">
                    <LabModalHeader title={t("infoTitle")} onClose={onClose} info={audience.name} hasClose />
                    <AudienceInfoModalBody />
                </div>
            </Modal>
        )
    );
});

export default AudienceInfoModal;
