import React from "react";
import { connect } from "react-redux";
import { useTranslation } from "react-i18next";
import { Textarea, TextInput } from "@lib/components/lego";

import { getDate } from "../utils/Date";
import { getSelectedAudienceState } from "./selectors";

const SIZE_S = "s";

const AudienceInfoModal = connect((state) => ({
    audience: getSelectedAudienceState(state),
}))((props) => {
    const { audience } = props;

    const { t, i18n } = useTranslation("audience");
    const lang = i18n.language;

    return (
        <div className="AudienceInfoModal-body">
            <table className="sample-params-table">
                <tbody>
                    <tr>
                        <td className="sample-param-label">{t("labels.id")}</td>
                        <td className="sample-param-value">
                            <TextInput size={SIZE_S} view="default" value={audience.id} disabled />
                        </td>
                    </tr>
                    <tr>
                        <td className="sample-param-label">{t("labels.name")}</td>
                        <td className="sample-param-value">
                            <TextInput size={SIZE_S} view="default" value={audience.name} disabled />
                        </td>
                    </tr>
                    <tr>
                        <td className="sample-param-label">{t("labels.purpose")}</td>
                        <td className="sample-param-value">
                            <Textarea size={SIZE_S} view="default" value={audience.purpose} rows={3} disabled />
                        </td>
                    </tr>
                    <tr>
                        <td className="sample-param-label">{t("labels.login")}</td>
                        <td className="sample-param-value">
                            <TextInput size={SIZE_S} view="default" value={audience.login} disabled />
                        </td>
                    </tr>
                    <tr>
                        <td className="sample-param-label">{t("labels.sourcePath")}</td>
                        <td className="sample-param-value">
                            <TextInput size={SIZE_S} view="default" value={audience.sourcePath} disabled />
                        </td>
                    </tr>
                    <tr>
                        <td className="sample-param-label">{t("labels.sourceField")}</td>
                        <td className="sample-param-value">
                            <TextInput size={SIZE_S} view="default" value={audience.sourceField} disabled />
                        </td>
                    </tr>
                    <tr>
                        <td className="sample-param-label">{t("labels.externalId")}</td>
                        <td className="sample-param-value">
                            <TextInput
                                size={SIZE_S}
                                view="default"
                                value={(audience.externalId || "—").toString()}
                                disabled
                            />
                        </td>
                    </tr>
                    <tr>
                        <td className="sample-param-label">{t("labels.created")}</td>
                        <td className="sample-param-value">
                            <TextInput
                                size={SIZE_S}
                                view="default"
                                value={getDate(lang, audience.timestamps.created, "LLL")}
                                disabled
                            />
                        </td>
                    </tr>
                    <tr>
                        <td className="sample-param-label">{t("labels.modified")}</td>
                        <td className="sample-param-value">
                            <TextInput
                                size={SIZE_S}
                                view="default"
                                value={getDate(lang, audience.timestamps.modified, "LLL")}
                                disabled
                            />
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    );
});

export default AudienceInfoModal;
