import React, { useEffect } from "react";
import { connect, useDispatch } from "react-redux";

import { fetchAudiences } from "src/actions";
import { getAccessState, getApiState, getAudiencesLoadedState, getVisibleModalState } from "../selectors";

import AudiencesHeader from "./AudiencesHeader";
import AudiencesTable from "./AudiencesTable";
import AudienceInfoModal from "./AudienceInfoModal";
import CreateAudienceModal from "./CreateAudienceModal";
import ModifyAudienceModal from "./ModifyAudienceModal";
import Failable from "../utils/Failable";
import Loading from "@lib/components/loading";
import { ForbiddenErrorPage } from "../utils/Errors";

import "./Audiences.scss";

const Audiences = connect((state) => ({
    api: getApiState(state),
    loaded: getAudiencesLoadedState(state),
    failed: state.base.failed,
    message: state.base.message,
    visibleCreate: getVisibleModalState(state, "CreateAudienceModal"),
    visibleModify: getVisibleModalState(state, "ModifyAudienceModal"),
    visibleInfo: getVisibleModalState(state, "AudienceInfoModal"),
}))((props) => {
    const { api, loaded, failed, message, visibleCreate, visibleModify, visibleInfo } = props;

    const dispatch = useDispatch();

    useEffect(() => {
        dispatch(fetchAudiences(api));
    }, []);

    return (
        <Failable failed={failed} errorMessage={message}>
            <div className="AudiencesLayoutBody">
                <AudiencesHeader />
                <Loading loaded={loaded}>
                    <AudiencesTable />
                </Loading>
                {visibleCreate && <CreateAudienceModal />}
                {visibleModify && <ModifyAudienceModal />}
                {visibleInfo && <AudienceInfoModal />}
            </div>
        </Failable>
    );
});

export default Audiences;
