import React, { Component } from "react";
import { connect } from "react-redux";
import { Button } from "@lib/components/lego/button";
import FontAwesome from "react-fontawesome";

import { showModal, fetchAudiences } from "./actions";
import { getApiState } from "../selectors";

import "./AudiencesHeader.scss";
import { withTranslation } from "react-i18next";

@withTranslation("audience")
@connect(
    (state) => ({
        api: getApiState(state),
    }),
    (dispatch) => ({
        showCreateAudienceModal: () => dispatch(showModal("CreateAudienceModal")),
        fetchAudiences: (api) => {
            dispatch(fetchAudiences(api));
        },
    })
)
class AudiencesHeader extends Component {
    render() {
        const { api, t } = this.props;

        return (
            <div className="AudiencesHeader">
                <div className="AudiencesHeader-internal">
                    <Button view="action" theme="action" size="s" onClick={() => this.props.showCreateAudienceModal()}>
                        <FontAwesome name="plus" />
                        {"  "}
                        {t("createSegment")}
                    </Button>
                    <Button
                        view="clear"
                        theme="normal"
                        size="s"
                        title={t("refreshSegmentsList")}
                        onClick={() => this.props.fetchAudiences(api)}
                    >
                        <FontAwesome name="refresh" />
                    </Button>
                </div>
            </div>
        );
    }
}

export default AudiencesHeader;
