import React, { Component } from "react";
import { connect } from "react-redux";

import { getAudiencesState } from "../selectors";
import AudiencesTableHeader from "./AudiencesTableHeader";
import AudiencesTableRow from "./AudiencesTableRow";

import "./AudiencesTable.scss";

@connect((state) => ({
    audiences: getAudiencesState(state),
}))
class AudiencesTable extends Component {
    render() {
        return (
            <table className="AudiencesTable">
                <thead>
                    <AudiencesTableHeader />
                </thead>
                <tbody>
                    {this.props.audiences.map((each) => (
                        <AudiencesTableRow key={each.id} audience={each} />
                    ))}
                </tbody>
            </table>
        );
    }
}

export default AudiencesTable;
