import React from "react";
import { connect, useDispatch } from "react-redux";
import { useTranslation } from "react-i18next";
import { Modal } from "@lib/components/lego";

import { hideModal } from "actions";
import { getVisibleModalState } from "./selectors";
import LabModalHeader from "../utils/LabModalHeader";
import CreateAudienceModalBody from "./CreateAudienceModalBody";
import { resetYtTableColumns } from "../utils/utilsActions";

import "./CreateAudienceModal.scss";

const CreateAudienceModal = connect((state) => ({
    visible: getVisibleModalState(state, "CreateAudienceModal"),
}))((props) => {
    const { visible } = props;
    const { t } = useTranslation("audience");
    const dispatch = useDispatch();

    const onClose = () => {
        dispatch(hideModal("CreateAudienceModal"));
        dispatch(resetYtTableColumns());
    };

    return (
        <Modal theme="normal" visible={visible} onClose={onClose}>
            <div className="CreateAudienceModal">
                <LabModalHeader title={t("createAudienceTitle")} hasClose onClose={onClose} />
                <CreateAudienceModalBody visible={visible} />
            </div>
        </Modal>
    );
});

export default CreateAudienceModal;
