import React from "react";
import { connect, useDispatch } from "react-redux";
import { useTranslation } from "react-i18next";
import { Modal } from "@lib/components/lego";
import { hideModal } from "./actions";
import { getSelectedAudienceState, getVisibleModalState } from "./selectors";
import ModifyAudienceModalBody from "./ModifyAudienceModalBody";
import LabModalHeader from "../utils/LabModalHeader";

const ModifyAudienceModal = connect((state) => ({
    visible: getVisibleModalState(state, "ModifyAudienceModal"),
    audience: getSelectedAudienceState(state),
}))((props) => {
    const { audience, visible } = props;
    const { t } = useTranslation("audience");
    const dispatch = useDispatch();

    const hide = () => dispatch(hideModal("ModifyAudienceModal"));

    return (
        audience && (
            <Modal theme="normal" onClose={hide} visible={visible}>
                <div className="ModifyAudienceModal">
                    <LabModalHeader title={t("modify.header")} info={audience.name} hasClose onClose={hide} />
                    <ModifyAudienceModalBody />
                </div>
            </Modal>
        )
    );
});

export default ModifyAudienceModal;
