import React, { Component } from "react";
import { connect } from "react-redux";
import { Button, TextInput } from "@lib/components/lego";
import { pick as _pick, some as _some } from "lodash";

import { modifyAudience } from "./actions";
import { getApiState, getSelectedAudienceState, getVisibleModalState } from "../selectors";
import { withTranslation } from "react-i18next";

const TEXT_INPUT_SIZE = "s";

@withTranslation("audience")
@connect(
    (state) => ({
        api: getApiState(state),
        visible: getVisibleModalState(state, "ModifyAudienceModal"),
        audience: getSelectedAudienceState(state),
    }),
    (dispatch) => ({
        modifyAudience: (api, params, setState) => dispatch(modifyAudience(api, params, setState)),
    })
)
class ModifyAudienceModalBody extends Component {
    constructor() {
        super();
        this.state = {
            id: "",
            sourcePath: "",
            sourceField: "",

            error: null,
            loaded: true,
            buttonDisabled: true,
        };
    }

    refreshState() {
        this.setState({
            id: this.props.audience.id,
            sourcePath: this.props.audience.sourcePath,
            sourceField: this.props.audience.sourceField,
            error: null,
            loaded: true,
            buttonDisabled: this.isButtonDisabled(this.getModifyAudienceParams(this.state)),
        });
    }

    componentDidMount() {
        this.refreshState();
    }

    componentDidUpdate(prevProps, prevState) {
        if (this.props.visible && !prevProps.visible) {
            this.refreshState();
        }

        const buttonDisabled = this.isButtonDisabled(this.getModifyAudienceParams(this.state));
        if (buttonDisabled !== prevState.buttonDisabled) {
            this.setState({ buttonDisabled: buttonDisabled });
        }
    }

    getModifyAudienceParams(obj) {
        return _pick(obj, ["id", "sourcePath", "sourceField"]);
    }

    isButtonDisabled(params) {
        return _some(params, (each) => !each);
    }

    render() {
        const { audience, t } = this.props;

        let disabled = !this.state.loaded || this.props.audience.state === "DELETED";
        return (
            <div className="ModifyAudienceModal-body">
                <table className="sample-params-table">
                    <tbody>
                        <tr>
                            <td className="sample-param-label">{t("modify.id")}</td>
                            <td className="sample-param-value">
                                <TextInput
                                    view="default"
                                    size={TEXT_INPUT_SIZE}
                                    value={this.state.id}
                                    onChange={(event) => this.setState({ id: event.target.value })}
                                    disabled
                                />
                            </td>
                        </tr>
                        <tr>
                            <td className="sample-param-label">{t("modify.name")}</td>
                            <td className="sample-param-value">
                                <TextInput view="default" size={TEXT_INPUT_SIZE} value={audience.name} disabled />
                            </td>
                        </tr>
                        <tr>
                            <td className="sample-param-label">{t("modify.login")}</td>
                            <td className="sample-param-value">
                                <TextInput view="default" size={TEXT_INPUT_SIZE} value={audience.login} disabled />
                            </td>
                        </tr>
                        <tr>
                            <td className="sample-param-label">{t("modify.sourcePath")}</td>
                            <td className="sample-param-value">
                                <TextInput
                                    view="default"
                                    size={TEXT_INPUT_SIZE}
                                    hasClear
                                    value={this.state.sourcePath}
                                    onChange={(event) => this.setState({ sourcePath: event.target.value })}
                                    disabled={disabled}
                                />
                            </td>
                        </tr>
                        <tr>
                            <td className="sample-param-label">{t("modify.sourceField")}</td>
                            <td className="sample-param-value">
                                <TextInput
                                    view="default"
                                    size={TEXT_INPUT_SIZE}
                                    hasClear
                                    value={this.state.sourceField}
                                    onChange={(event) => this.setState({ sourceField: event.target.value })}
                                    disabled={disabled}
                                />
                            </td>
                        </tr>
                    </tbody>
                </table>

                <Button
                    view="action"
                    theme="action"
                    size="s"
                    onClick={() => {
                        this.setState({ loaded: false });
                        this.props.modifyAudience(
                            this.props.api,
                            this.getModifyAudienceParams(this.state),
                            this.setState.bind(this)
                        );
                    }}
                    disabled={this.state.buttonDisabled || disabled}
                >
                    {t("modify.button")}
                </Button>
            </div>
        );
    }
}

export default ModifyAudienceModalBody;
