import React, { Component } from "react";
import { withTranslation } from "react-i18next";

const STATE_LABEL = {
    READY: "ready",
    CREATING: "creating",
    MODIFYING: "modifying",
    DELETING: "deleting",
    ERROR_CREATING: "errorCreating",
    ERROR_MODIFYING: "errorModifying",
    ERROR_DELETING: "errorDeleting",
    DELETED: "deleted",
};

const STATE_COLOR = {
    READY: "green",
    CREATING: "yellow",
    MODIFYING: "green",
    DELETING: "yellow",
    ERROR_CREATING: "red",
    ERROR_MODIFYING: "red",
    ERROR_DELETING: "red",
    DELETED: "red",
};

@withTranslation("audience")
class State extends Component {
    render() {
        return (
            <span className="State">
                <span className={"AudienceState-icon icon-" + STATE_COLOR[this.props.state]} />
                {this.props.t(`state.${STATE_LABEL[this.props.state]}`)}
            </span>
        );
    }
}

export default State;
