import { createAction } from "redux-actions";
import { reachGoal } from "metrika";
import { push } from "connected-react-router";
import qs from "query-string";

export const requestAudiences = createAction("request audiences");
export const receiveAudiences = createAction("receive audiences");
export const failedAudiences = createAction("failed audiences");
export const showModal = createAction("show modal");
export const hideModal = createAction("hide modal");

export const requestGrabId = createAction("request grab id");
export const receiveGrabId = createAction("receive grab id");
export const failedGrabId = createAction("failed grab id");

export const requestAuth = createAction("request auth");
export const receiveAuth = createAction("receive auth");
export const failedAuth = createAction("failed auth");

export function fetchAudiences(api) {
    return (dispatch) => {
        dispatch(requestAudiences());
        api.then((api) => api.apis.lab.getMyAudiences)
            .then((method) => method())
            .then((response) => {
                dispatch(receiveAudiences(response.obj));
            })
            .catch((error) => {
                if (error.obj) {
                    dispatch(failedAudiences(error.obj.message));
                } else {
                    console.error(error);
                    dispatch(failedAudiences("Unknown error"));
                }
            });
    };
}

export function createGrabId(api, extLogin) {
    return (dispatch) => {
        dispatch(requestGrabId());
        return api
            .then((api) => api.apis.lab.createGrab)
            .then((method) => method({ ext_login: extLogin }))
            .then((response) => {
                let grabId = response.obj.grabId;
                dispatch(receiveGrabId(grabId));
                return grabId;
            })
            .catch((error) => {
                if (error.obj) {
                    dispatch(failedGrabId(error.obj.message));
                } else {
                    console.error(error);
                    dispatch(failedGrabId("Unknown error"));
                }
            });
    };
}

export function checkAuth(api, extLogin, grabId) {
    return (dispatch) => {
        dispatch(requestAuth());
        api.then((api) => api.apis.lab.checkAudienceAuth)
            .then((method) => method({ ext_login: extLogin, grab_id: grabId }))
            .then((response) => {
                let authResult = JSON.parse(response.data);
                dispatch(receiveAuth(authResult));
                return authResult;
            })
            .catch((error) => {
                if (error.obj) {
                    dispatch(failedAuth(error.obj));
                } else {
                    console.error(error);
                    dispatch(failedAuth("Unknown error"));
                }
            });
    };
}

export function selectAudience(id) {
    return (dispatch) => {
        dispatch(push({ search: "?" + qs.stringify({ selected: id }) }));
    };
}

export function createAudience(api, params, setState) {
    return (dispatch) => {
        dispatch(reachGoal("createAudience"));
        api.then((api) => api.apis.lab.createAudience)
            .then((method) => method(params))
            .then((response) => {
                dispatch(reachGoal("createAudienceSuccess"));
                dispatch(hideModal("CreateAudienceModal"));
                dispatch(selectAudience(response.obj.id));
                dispatch(fetchAudiences(api));
            })
            .catch((error) => {
                dispatch(reachGoal("createAudienceFail"));
                setState({ error: error, loaded: true });
            });
    };
}

export function modifyAudience(api, params, setState) {
    return (dispatch) => {
        dispatch(reachGoal("modifyAudience"));
        api.then((api) => api.apis.lab.modifyAudience)
            .then((method) => method(params))
            .then((response) => {
                dispatch(reachGoal("modifyAudienceSuccess"));
                dispatch(hideModal("ModifyAudienceModal"));
                dispatch(selectAudience(response.obj.id));
                dispatch(fetchAudiences(api));
            })
            .catch((error) => {
                dispatch(reachGoal("modifyAudienceFail"));
                setState({ error: error, loaded: true });
            });
    };
}

export function deleteAudience(api, id) {
    return (dispatch) => {
        dispatch(reachGoal("deleteAudience"));
        return api
            .then((api) => api.apis.lab.deleteAudience)
            .then((method) => method({ id: id }))
            .then((response) => {
                dispatch(reachGoal("deleteAudienceSuccess"));
                dispatch(fetchAudiences(api));
            })
            .catch((error) => {
                console.error("Failed to delete audience", id);
                dispatch(reachGoal("deleteAudienceFail"));
            });
    };
}

export function deleteLabAudience(api, id) {
    return (dispatch) => {
        dispatch(reachGoal("deleteLabAudience"));
        return api
            .then((api) => api.apis.lab.deleteLabAudience)
            .then((method) => method({ id: id }))
            .then((response) => {
                dispatch(reachGoal("deleteLabAudienceSuccess"));
                dispatch(selectAudience(undefined));
                dispatch(fetchAudiences(api));
            })
            .catch((error) => {
                console.error("Failed to delete audience from Lab");
                dispatch(reachGoal("deleteLabAudienceFail"));
            });
    };
}
