import { handleActions } from "redux-actions";
import _ from "lodash";

import {
    requestAudiences,
    receiveAudiences,
    failedAudiences,
    showModal,
    hideModal,
    requestGrabId,
    receiveGrabId,
    failedGrabId,
    requestAuth,
    receiveAuth,
    failedAuth,
} from "actions";

export const audiencesReducer = handleActions(
    {
        [requestAudiences]: (state) => {
            return {
                ...state,
                loaded: false,
            };
        },
        [receiveAudiences]: (state, { payload }) => ({
            ...state,
            audiences: _.sortBy(payload, (audience) => -audience["timestamps"]["modified"]),
            loaded: true,
        }),
        [failedAudiences]: (state, { payload }) => ({
            ...state,
            failed: true,
            message: obtainMessage(payload),
        }),
        [showModal]: (state, { payload }) => {
            return {
                ...state,
                ["visible" + payload]: true,
            };
        },
        [hideModal]: (state, { payload }) => ({
            ...state,
            ["visible" + payload]: false,
        }),
        [requestGrabId]: (state) => {
            return {
                ...state,
                loadedGrabId: false,
            };
        },
        [receiveGrabId]: (state, { payload }) => {
            return {
                ...state,
                grabId: payload,
            };
        },
        [failedGrabId]: (state, { payload }) => {
            return {
                ...state,
                failedGrab: true,
                message: obtainMessage(payload),
            };
        },
        [requestAuth]: (state) => {
            return {
                ...state,
                passportAuth: false,
            };
        },
        [receiveAuth]: (state, { payload }) => {
            return {
                ...state,
                passportAuth: payload,
            };
        },
        [failedAuth]: (state, { payload }) => {
            return {
                ...state,
                passportAuth: false,
                message: obtainMessage(payload),
            };
        },
    },
    {
        loaded: false,
        visibleCreateAudienceModal: false,
        visibleAudienceInfoModal: false,
        visibleModifyAudienceModal: false,
    }
);

function obtainMessage(error) {
    if (_.isString(error)) {
        return error;
    }
    if (_.isObject(error)) {
        if (error.obj) {
            return error.obj.message || "Unknown error";
        } else {
            return error;
        }
    }
}
