import { createSelector } from "reselect";
import qs from "query-string";
import { find as _find } from "lodash";

const getAudiencesLoaded = (state) => state.audiences.loaded;
export const getAudiencesLoadedState = createSelector(getAudiencesLoaded, (data) => data);

const getAudiences = (state) => state.audiences.audiences;
export const getAudiencesState = createSelector([getAudiences], (data) => data);

const getAudiencesGlobal = (state) => state.audiences;
export const getAudiencesGlobalState = createSelector([getAudiencesGlobal], (data) => data);

const getVisibleModal = (state, modalName) => state.audiences["visible" + modalName];
export const getVisibleModalState = createSelector([getVisibleModal], (data) => data);

const getSelectedAudienceId = (state) => {
    let location = state.router.location;
    return qs.parse(location.search).selected || undefined;
};
export const getSelectedAudienceIdState = createSelector(getSelectedAudienceId, (data) => data);

export const getSelectedAudienceState = createSelector([getAudiences, getSelectedAudienceId], (audiences, audienceId) =>
    _find(audiences, (each) => each.id === audienceId)
);
