import i18n from "i18next";
import { initReactI18next } from "react-i18next";
import Backend from "i18next-xhr-backend";
import LanguageDetector from "i18next-browser-languagedetector";

import common_en from "./en/common.json";
import common_ru from "./ru/common.json";
import condition_en from "./en/condition.json";
import condition_ru from "./ru/condition.json";
import errors_en from "./en/errors.json";
import errors_ru from "./ru/errors.json";
import siberia_en from "./en/siberia.json";
import siberia_ru from "./ru/siberia.json";
import samples_en from "./en/samples.json";
import samples_ru from "./ru/samples.json";
import segments_en from "./en/segments.json";
import segments_ru from "./ru/segments.json";
import segment_export_en from "./ru/segmentExport.json";
import segment_export_ru from "./ru/segmentExport.json";
import audience_en from "./en/audience.json";
import audience_ru from "./ru/audience.json";
import createSample_en from "./en/createSample.json";
import createSample_ru from "./ru/createSample.json";
import sampleView_en from "./en/sampleView.json";
import sampleView_ru from "./ru/sampleView.json";
import stats_en from "./en/stats.json";
import stats_ru from "./ru/stats.json";
import trainingSamples_en from "./en/trainingSamples.json";
import trainingSamples_ru from "./ru/trainingSamples.json";
import utils_en from "./en/utils.json";
import utils_ru from "./ru/utils.json";

import lib_en from "@lib/i18n/en/lib.json";
import lib_ru from "@lib/i18n/ru/lib.json";

i18n
    // load translation using xhr -> see /public/locales (i.e. https://github.com/i18next/react-i18next/tree/master/example/react/public/locales)
    // learn more: https://github.com/i18next/i18next-xhr-backend
    .use(Backend)
    // detect user language
    // learn more: https://github.com/i18next/i18next-browser-languageDetector
    .use(LanguageDetector)
    // pass the i18n instance to react-i18next.
    .use(initReactI18next)
    // init i18next
    // for all options read: https://www.i18next.com/overview/configuration-options
    .init({
        fallbackLng: "ru",
        debug: true,
        lng: "ru",

        react: {
            useSuspense: false,
        },

        interpolation: {
            escapeValue: false, // not needed for react as it escapes by default
        },

        resources: {
            en: {
                common: common_en,
                condition: condition_en,
                samples: samples_en,
                stats: stats_en,
                trainingSamples: trainingSamples_en,
                createSample: createSample_en,
                sampleView: sampleView_en,
                segments: segments_en,
                segmentExport: segment_export_en,
                audience: audience_en,
                siberia: siberia_en,
                errors: errors_en,
                lib: lib_en,
                utils: utils_en,
            },
            ru: {
                common: common_ru,
                condition: condition_ru,
                samples: samples_ru,
                stats: stats_ru,
                trainingSamples: trainingSamples_ru,
                createSample: createSample_ru,
                sampleView: sampleView_ru,
                segments: segments_ru,
                segmentExport: segment_export_ru,
                audience: audience_ru,
                siberia: siberia_ru,
                errors: errors_ru,
                lib: lib_ru,
                utils: utils_ru,
            },
        },
    });

export default i18n;
