import React from "react";
import ReactDOM from "react-dom";
import App from "App";
import "index.scss";
import "@lib/fonts/font-awesome.css";
import "fonts/fonts.scss";

import { Provider } from "react-redux";
import { createStore, applyMiddleware, compose } from "redux";
import thunk from "redux-thunk";
import createRootReducer from "reducers";
import createHistory from "history/createBrowserHistory";
import { routerMiddleware, ConnectedRouter } from "connected-react-router";
import { configureLego } from "@lib/components/lego";
import ErrorBoundary from "@lib/components/errorboundary";

import "./i18n/config";

const history = createHistory();

configureLego();

const middleware = [applyMiddleware(thunk), applyMiddleware(routerMiddleware(history))];

const store = compose(...middleware)(createStore)(
    createRootReducer(history),
    window.__REDUX_DEVTOOLS_EXTENSION__ && window.__REDUX_DEVTOOLS_EXTENSION__()
);

ReactDOM.render(
    <ErrorBoundary>
        <Provider store={store}>
            <ConnectedRouter history={history}>
                <App />
            </ConnectedRouter>
        </Provider>
    </ErrorBoundary>,
    document.getElementById("root")
);
