import { createAction, handleActions } from "redux-actions";
import { isUndefined } from "lodash";
import Cookies from "universal-cookie";

export const reachGoal = createAction("react metrika goal");

export const metrikaReducer = handleActions(
    {
        [reachGoal]: (state, { payload }) => {
            if (window.location.hostname.startsWith("lab.crypta")) {
                if (!isUndefined(window.yaCounter47167362)) {
                    window.yaCounter47167362.reachGoal(payload);
                }
            } else {
                console.log("reaching goal " + payload);
            }
            return state;
        },
    },
    {}
);

export const provideUserParams = () => {
    const cookies = new Cookies();
    const login = cookies.get("yandex_login", "unknown");
    if (!isUndefined(window.yaCounter47167362)) {
        window.yaCounter47167362.userParams({ UserID: login });
    }
};
