import {
    failedSampleStats,
    receiveSampleStats,
    requestSampleStats,
    setSampleStatsNotFound,
} from "../samples/actions";

export function fetchStats(api, sample, group, baseId, baseGroup) {
    return (dispatch) => {
        dispatch(requestSampleStats());
        let parameters = { id: sample.id, groupId: group, baseSampleId: baseId, baseGroupId: baseGroup };
        return api
            .then((api) => api.apis.lab.getSampleStats)
            .then((method) => method(parameters))
            .then((stats) => {
                dispatch(receiveSampleStats(stats.obj));
            })
            .catch((error) => {
                if (error.status === 404) {
                    dispatch(setSampleStatsNotFound());
                }
                dispatch(failedSampleStats(error));
            });
    };
}

export function fetchStatsBySegment(api, sample, group, baseSegment) {
    return (dispatch) => {
        dispatch(requestSampleStats());
        let parameters = {
            id: sample.id,
            segmentId: baseSegment,
            groupId: group,
        };
        return api
            .then((api) => api.apis.lab.getSampleStatsBySegmentId)
            .then((method) => method(parameters))
            .then((stats) => dispatch(receiveSampleStats(stats.obj)))
            .catch((error) => {
                if (error.status === 404) {
                    dispatch(setSampleStatsNotFound());
                }
                dispatch(failedSampleStats(error));
            });
    };
}
