import React from "react";
import { useTranslation } from "react-i18next";
import { connect } from "react-redux";
import { TextInput, Select } from "@lib/components/lego";
import { isEmpty } from "lodash";

import AccessLevelSelect from "../../samples/AccessLevelSelect";
import ValidableYtPath from "../../utils/ValidableYtPath";
import IdTypeSelect from "../../samples/IdTypeSelect";

import { getSrcTableColumnsState } from "../../selectors";

import "../../samples/CreateSampleModal.scss";

const YT_PATH_PLACEHOLDER = "//path/to/mySuperCoolDatedSample";
const TEXT_INPUT_SIZE = "m";
const TTL_PLACEHOLDER = "7";


const ImportDatedSampleParams = connect(state => ({
    srcYtColumns: getSrcTableColumnsState(state).columns,
    srcTableValid: !isEmpty(getSrcTableColumnsState(state).columns),
}))((props) => {
    const {
            name,
            path,
            idType,
            idKey,
            dateKey,
            ttl,
            accessLevel,
            disabled,
            isAdmin,
            onMouseOver,
            onMouseOut,
            srcYtColumns,
            srcTableValid,
            onParameterChange
    } = props;
    const { t } = useTranslation("createSample");
    return (
        <div className="import-sample-params">
            <table className="sample-params-table">
                <tbody>
                    <tr>
                        <td className="sample-param-label">{t("name")}</td>
                        <td className="sample-param-value">
                            <TextInput
                                view="default"
                                theme="normal"
                                size={TEXT_INPUT_SIZE}
                                hasClear
                                value={name}
                                placeholder={t("namePlaceholder")}
                                onChange={(event) => onParameterChange(event.target.value, "name")}
                                disabled={disabled}
                            />
                        </td>
                    </tr>
                    <tr onMouseOver={() => onMouseOver("path")} onMouseOut={onMouseOut}>
                        <td className="sample-param-label">{t("source")}</td>
                        <td className="sample-param-value">
                            <ValidableYtPath>
                                <TextInput
                                    view="default"
                                    theme="normal"
                                    size={TEXT_INPUT_SIZE}
                                    hasClear
                                    value={path}
                                    placeholder={YT_PATH_PLACEHOLDER}
                                    onChange={(event) => onParameterChange(event.target.value, "path")}
                                    disabled={disabled}
                                />
                            </ValidableYtPath>
                        </td>
                    </tr>
                    <tr onMouseOver={() => onMouseOver("idKey")} onMouseOut={onMouseOut}>
                        <td className="sample-param-label">{t("column")}</td>
                        <td className="sample-param-value">
                            <Select
                                size={TEXT_INPUT_SIZE}
                                view="default"
                                width="max"
                                onChange={(event) => onParameterChange(event.target.value, "idKey")}
                                value={idKey}
                                options={srcYtColumns.map((column) => ({ value: column.name, content: column.name }))}
                                disabled={disabled || !srcTableValid}
                            />
                        </td>
                    </tr>
                    <tr onMouseOver={() => onMouseOver("idType")} onMouseOut={onMouseOut}>
                        <td className="sample-param-label">
                            {t("idType")}
                        </td>
                        <td className="sample-param-value">
                            <IdTypeSelect
                                value={idType}
                                onChange={(value) => onParameterChange(value, "idType")}
                            />
                        </td>
                    </tr>
                    <tr onMouseOver={() => onMouseOver("dateKey")} onMouseOut={onMouseOut}>
                        <td className="sample-param-label">{t("dateField")}</td>
                        <td className="sample-param-value">
                            <Select
                                size={TEXT_INPUT_SIZE}
                                view="default"
                                width="max"
                                onChange={(event) => onParameterChange(event.target.value, "dateKey")}
                                value={dateKey}
                                options={srcYtColumns.filter((column) => column.name !== idKey).map((column) => ({ value: column.name, content: column.name }))}
                                disabled={disabled || !srcTableValid}
                            />
                        </td>
                    </tr>
                    <tr onMouseOver={() => onMouseOver("ttl")} onMouseOut={onMouseOut}>
                        <td className="sample-param-label">
                            {t("storeFor")} ({t("days")})
                        </td>
                        <td className="sample-param-value">
                            <span className="ttl-input">
                                <TextInput
                                    view="default"
                                    theme="normal"
                                    size={TEXT_INPUT_SIZE}
                                    value={ttl}
                                    placeholder={TTL_PLACEHOLDER}
                                    onChange={(event) => onParameterChange(event.target.value, "ttl")}
                                    disabled={disabled}
                                />
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td className="sample-param-label">{t("access")}</td>
                        <td className="sample-param-value">
                            <AccessLevelSelect
                                value={accessLevel}
                                onChange={(value) => onParameterChange(value, "accessLevel")}
                                isAdmin={isAdmin}
                            />
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    );
});

export default ImportDatedSampleParams;
