import React from "react";
import { connect } from "react-redux";
import { isEmpty } from "lodash";

import { Modal } from "@lib/components/lego";

import OldSampleStats from "./OldSampleStats";
import SampleStatsModalHeader from "../../samples/stats/SampleStatsModalHeader";
import BaseStatsParams from "../../stats/BaseStatsParams";

import { getSamplesState, getSelectedSampleState } from "../../samples/selectors";
import { getApiState } from "../../selectors";

import { closeSampleStats } from "../../samples/actions";
import { fetchStats, fetchStatsBySegment } from "../actions";


const DatedSampleStatsModal = connect((state) => ({
    api: getApiState(state),
    visible: getSamplesState(state).modals.stats,
    sample: getSelectedSampleState(state),
}))((props) => {
    const { api, visible, sample, dispatch } = props;

    const close = () => dispatch(closeSampleStats());

    return (
        !isEmpty(sample) && (
            <Modal theme="normal" visible={visible} hasAnimation={false} onClose={close}>
                <div className="StatsModal">
                    <SampleStatsModalHeader />
                    <BaseStatsParams
                        fetchStats={() => fetchStats(api, sample, undefined, "", "")}
                        fetchStatsBySample={(baseId, baseGroup, baseSetId) => fetchStats(api, sample, undefined, baseId, baseGroup)}
                        fetchStatsByExport={(baseId) => fetchStatsBySegment(api, sample, undefined, baseId)}
                    />
                    <OldSampleStats />
                </div>
            </Modal>
        )
    );
});

export default DatedSampleStatsModal;
