import React, { useEffect } from "react";
import { useTranslation } from "react-i18next";
import { connect } from "react-redux";

import { Spin } from "@lib/components/lego";
import SampleStats from "@lib/stats/SampleStats";

import StatsNotReady from "../../stats/StatsNotReady";

import { getSamplesState, getSelectedGroupState, getSelectedSampleState } from "../../samples/selectors";
import { fetchStats } from "../actions";
import { getApiState } from "../../selectors";

import "../../stats/style.scss";

const OldSampleStats = connect((state) => ({
    api: getApiState(state),
    sample: getSelectedSampleState(state),
    stats: getSamplesState(state).stats,
    loaded: getSamplesState(state).loadedStats,
    failed: getSamplesState(state).errorStats,
    group: getSelectedGroupState(state),
    notFound: getSamplesState(state).sampleStatsNotFound,
    notReady: getSamplesState(state).sampleStatsNotReady && !getSamplesState(state).errorStats,
}))((props) => {
    const { api, sample, group, stats, loaded, failed, notFound, notReady, dispatch } = props;

    const { t } = useTranslation("stats");

    const exportFileBasename = sample.id + "_" + group;

    useEffect(() => {
        dispatch(fetchStats(api, sample, group, "", ""));
    }, [sample, group]);

    const progress = !loaded && !failed;

    return (
        <div className="Stats">
            {progress && (
                <div className="Stats-loading-status">
                    <Spin progress view="default" size="s" />
                </div>
            )}
            {notReady && !progress && (
                <div className="Stats-loading-status">
                    <StatsNotReady reloadFunc={fetch} />
                </div>
            )}
            {notFound && <div className="Stats-loading-status">{t("notFound")}</div>}
            {loaded && !notReady && (
                <SampleStats
                    loaded={loaded}
                    stats={stats}
                    exportFileBasename={exportFileBasename}
                    withLoading={false}
                />
            )}
        </div>
    );
});

export default OldSampleStats;
