import React from "react";
import { useTranslation } from "react-i18next";
import { Button } from "@lib/components/lego";

import "./style.scss";

const SampleStatus = (props) => {
    const { t } = useTranslation("samples");

    const status = {
        CREATED: t("status.CREATED"),
        ERROR: t("status.ERROR"),
        READY: t("status.READY"),
        PROCESSING: t("status.PROCESSING"),
    };
    const state = props.state;
    const disabled = state !== "ERROR";

    return (
        disabled ? (
            <div className={`SampleStatus${state == 'READY' ? "-green" : ""}`}>
                {status[state]}
            </div>
            ) : (
                <Button
                    view="clear"
                    theme="clear"
                    size="ss"
                    title={t("details")}
                    onClick={props.onClick}
                    className="SampleErrorButton"
                >
                    <div className={"SampleErrorButton-error"}>
                        {status[state]}
                    </div>
                </Button>
            )

    );
};

export default SampleStatus;
