import React from "react";
import FontAwesome from "react-fontawesome";
import { useTranslation } from "react-i18next";
import { connect, useDispatch } from "react-redux";
import { isEmpty } from "lodash";

import { Button } from "@lib/components/lego";
import Link from "@lib/components/link";
import Id from "../../utils/Id";
import YtPathLink from "../../utils/YtPath";

import { getApiState } from "../../selectors";
import { openSampleTablePreview } from "../../samples/actions";
import sandboxPic from "src/images/sandbox.png";

import "../../samples/SampleViewsModal.scss";

const SANDBOX_TASK_BASE_URL = "https://sandbox.yandex-team.ru/tasks/?tags=CRYPTA.LAB.LIB.LOOKALIKE.LOOKALIKE,";


const DatedSampleViewRow = connect(state => ({
    api: getApiState(state),
}))((props) =>  {
    const { view, api } = props;
    const { t } = useTranslation(["sampleView"]);

    const { Lookalike: lookalike } = view.Options;
    const { SampleID: sampleId, ID: id, Path: tablePath, Error: Error } = view;

    const dispatch = useDispatch();

    const openPreview = (api, sampleId, viewId) => dispatch(openSampleTablePreview(api, sampleId, viewId));

    const isLookalikeView = view.Type === "LOOKALIKE";

    const renderTable = () => {
        return (
            <div className="SampleTablePath">
                <span className="SamplePreview">
                    <Button
                        view="clear"
                        theme="normal"
                        size="s"
                        title={t("instantView")}
                        onClick={() => openPreview(api, sampleId, id)}
                    >
                        <FontAwesome name="search" />
                    </Button>
                </span>
                <YtPathLink tablePath={tablePath} linkTitle={t("toToYt")} />
            </div>
        );
    };

    return (
        <tr className="SamplesViewsTableRow">
            <td>
                <Id value={view.ID} copyable={false} />
            </td>
            <td key="size" className="Size">
                {isLookalikeView ? "" + lookalike.Counts.Output : "-"}
            </td>
            <td>{renderTable()}</td>
            <td>{t("state." + view.State)}</td>
            <td>
                {isLookalikeView && (
                    <Link href={SANDBOX_TASK_BASE_URL + sampleId + '&all_tags=true'} target="_blank">
                        <img alt="Sandbox" className="SandboxLink" src={sandboxPic}/>
                    </Link>
                )}
            </td>
            {
                !isEmpty(Error) && (
                    <td>
                        <FontAwesome
                            title={t("error." + Error)}
                            className="Error-pic"
                            name="exclamation-circle"
                        />
                    </td>
                )
            }
        </tr>
    );
});


export default DatedSampleViewRow;
