import React from "react";
import { useTranslation } from "react-i18next";
import { map as _map } from "lodash";

import DatedSampleViewRow from "./ViewTableRow";

import "../../samples/SampleViewsModal.scss";


const DatedSampleViewsTable = (props) => {
    const { views } = props;
    const { t } = useTranslation(["samples"]);

    return (
        <table className="SamplesViewsTable">
            <thead key="head">
                <tr className="SamplesViewsTableHeader">
                    <th>{t("viewHeaders.id")}</th>
                    <th>{t("viewHeaders.size")}</th>
                    <th>{t("viewHeaders.path")}</th>
                    <th>{t("viewHeaders.state")}</th>
                    <th>{t("viewHeaders.sandboxLink")}</th>
                </tr>
            </thead>
            <tbody key="body">
                {
                    _map(views, (each) => (<DatedSampleViewRow key={each.ID} view={each} />))
                }
            </tbody>
        </table>
    );
};

export default DatedSampleViewsTable;
