import { handleActions } from "redux-actions";
import {
    changeLanguage,
    requestRoles,
    receiveRoles,
    failedRoles,
    gotApi,
    failedApi,
    failedSegments,
    updateNow,
} from "actions";
import { crypta_api, phf_api, auth_url } from "api-middleware";
import { audiencesReducer } from "audiences/reducers";
import { segmentsReducer } from "segments/reducers";
import { samplesReducer } from "samples/reducers";
import { metrikaReducer } from "metrika";
import { connectRouter } from "connected-react-router";
import { combineReducers } from "redux";
import { utilsReducer } from "./utils/utilsReducers";
import { audiencesSegmentReducer } from "segments/audience/audienceReducers";
import { notificationsReducer } from "./utils/notifications/notificationsState";
import { segmentsFilterReducer } from "src/segments/filter/filterReducer";
import { setEnvType } from "./actions";
import { segmentExportsReducer } from "./segments/export/exportReducers";
import { tankerReducer } from "./segments/card/tanker/reducers";
import { ruleReducer } from "./segments/rule/reducers";
import { trainingSamplesReducer } from "./training_samples/reducers";

export const baseReducer = handleActions(
    {
        [changeLanguage]: (state, { payload }) => ({ ...state, lang: payload }),
        [requestRoles]: (state) => ({ ...state, access: null, message: null }),
        [receiveRoles]: (state, { payload }) => ({
            ...state,
            access: payload,
            message: null,
        }),
        [failedRoles]: (state, { payload }) => ({
            ...state,
            failed: true,
            message: payload,
        }),
        [gotApi]: (state, { payload }) => ({
            ...state,
            apiInfo: { version: payload.version, host: payload.host },
        }),
        [failedApi]: (state, { payload }) => ({
            ...state,
            failed: true,
            message: payload,
        }),
        [failedSegments]: (state, { payload }) => ({
            ...state,
            failed: true,
            message: payload,
        }),
        [updateNow]: (state, { payload }) => ({ ...state, now: payload }),
        [setEnvType]: (state, { payload }) => ({
            ...state,
            envType: payload,
        }),
    },
    {
        lang: "ru",
        version: null, // PLACEHOLDER replaced by webpack
        api: crypta_api,
        apiInfo: {},
        phf_api: phf_api,
        access: null,
        failed: false,
        now: Date.now(),
        authUrl: auth_url,
        envType: "testing",
    }
);

export default (history) =>
    combineReducers({
        router: connectRouter(history),
        base: baseReducer,
        audiences: audiencesReducer,
        segments: segmentsReducer,
        segmentsFilter: segmentsFilterReducer,
        segmentExports: segmentExportsReducer,
        samples: samplesReducer,
        trainingSamples: trainingSamplesReducer,
        metrika: metrikaReducer,
        utils: utilsReducer,
        rule: ruleReducer,
        segmentAudience: audiencesSegmentReducer,
        notifications: notificationsReducer,
        tanker: tankerReducer,
    });
