import React from "react";
import { useTranslation } from "react-i18next";
import { Select } from "@lib/components/lego";

const PRIVATE = "PRIVATE";
const SHARED = "SHARED";
const PUBLIC = "PUBLIC";

const AccessLevelSelect = (props) => {
    const { value, onChange, isAdmin } = props;
    const { t } = useTranslation("samples");

    let accessLevels = [
        { value: PRIVATE, content: t("info.accessLevel.private") },
        { value: SHARED, content: t("info.accessLevel.shared") },
    ];

    if (isAdmin) {
        accessLevels.push({ value: PUBLIC, content: t("info.accessLevel.public") });
    }

    return (
        <Select
            view="default"
            size="m"
            width="fixed"
            value={value}
            onChange={(event) => onChange(event.target.value)}
            options={accessLevels}
        />
    );
};

export default AccessLevelSelect;
