import React from "react";
import { Select } from "@lib/components/lego";
import { connect } from "react-redux";
import { getSrcTableColumnsState } from "../selectors";
import { isEmpty } from "lodash";

const IdTypeSelect = connect((state) => ({
    srcYtColumns: getSrcTableColumnsState(state),
}))((props) => {
    const { value, onChange, disabled, srcYtColumns } = props;

    const srcYtTableValid = !isEmpty(srcYtColumns.columns);

    return (
        <Select
            size="m"
            view="default"
            width="max"
            onChange={(event) => onChange(event.target.value)}
            value={value}
            options={
                srcYtTableValid
                    ? srcYtColumns.columns
                          .find((element, array, index) => element.name === srcYtColumns.activeColumn)
                          .idTypes.map((x) => ({ value: x, content: x }))
                    : []
            }
            disabled={disabled}
        />
    );
});

export default IdTypeSelect;
