import React from "react";
import { useTranslation } from "react-i18next";
import { isEmpty } from "lodash";
import { Modal } from "@lib/components/lego";
import Id from "../utils/Id";
import { connect, useDispatch } from "react-redux";
import { getSamplesState } from "./selectors";
import { closeSampleInfo } from "./actions";
import Date from "../utils/Date";
import User from "../utils/User";
import LabModalHeader from "../utils/LabModalHeader";

import "./SampleInfoModal.scss";

const SampleInfo = (props) => {
    const { sample } = props;

    const { t, i18n } = useTranslation("samples");
    const lang = i18n.language;

    const accessLevel = {
        PUBLIC: t("info.accessLevel.private"),
        SHARED: t("info.accessLevel.shared"),
        PRIVATE: t("info.accessLevel.private"),
    };

    if (!sample) {
        return null;
    }

    return (
        <div className="SampleInfo-content">
            <table className="SampleInfo-table">
                <tbody>
                    <tr>
                        <td className="SampleInfo-label">{t("info.author")}</td>
                        <td className="SampleInfo-value">
                            <User login={sample.author} />
                        </td>
                    </tr>
                    <tr>
                        <td className="SampleInfo-label">{t("info.access")}</td>
                        <td className="SampleInfo-value">{accessLevel[sample.accessLevel]}</td>
                    </tr>
                    <tr>
                        <td className="SampleInfo-label">{t("info.identifiers")}</td>
                        <td className="SampleInfo-value">
                            <Id value={sample.idName} /> {t("info.inField") + " "}
                            <Id value={sample.idKey} />
                            {sample.groupingKey ? (
                                <span>
                                    {", "}
                                    <br />
                                    {t("info.groupedBy") + " "}
                                    <Id value={sample.groupingKey} />
                                </span>
                            ) : (
                                ""
                            )}
                        </td>
                    </tr>
                    {!isEmpty(sample.dateKey) && (
                        <tr>
                            <td className="SampleInfo-label">{t("info.dateField")}</td>
                        <td className="SampleInfo-value"><Id value={sample.dateKey} /></td>
                        </tr>
                    )}
                    <tr>
                        <td className="SampleInfo-label">{t("info.created")}</td>
                        <td className="SampleInfo-value">
                            <Date lang={lang} value={sample.timestamps.created} />
                        </td>
                    </tr>
                    <tr>
                        <td className="SampleInfo-label">{t("info.modified")}</td>
                        <td className="SampleInfo-value">
                            <Date lang={lang} value={sample.timestamps.modified} />
                        </td>
                    </tr>
                    <tr>
                        <td className="SampleInfo-label">{t("info.deleted")}</td>
                        <td className="SampleInfo-value">
                            <Date lang={lang} value={sample.timestamps.modified + sample.ttl} />
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    );
};

const SampleInfoModal = connect((state) => ({
    visible: getSamplesState(state).modals.info,
}))((props) => {
    const { visible, sample } = props;

    const dispatch = useDispatch();

    const onClose = () => dispatch(closeSampleInfo());

    return (
        <Modal theme="normal" onClose={onClose} visible={visible}>
            {sample && (
                <div className="SampleInfo-modal-content">
                    <LabModalHeader title={sample.name} info={sample.id} hasClose onClose={onClose} />
                    <div key="stats" className="SampleInfo-main">
                        <SampleInfo sample={sample} />
                    </div>
                </div>
            )}
        </Modal>
    );
});

export default SampleInfoModal;
