import React from "react";
import { connect, useDispatch } from "react-redux";
import { Modal } from "@lib/components/lego";
import { isEmpty } from "lodash";

import { closeSampleTableView } from "src/samples/actions";
import { getSamplesState } from "src/selectors";
import Loading from "@lib/components/loading";
import Failable from "src/utils/Failable";
import { useTranslation } from "react-i18next";

import "./SampleViewTableModal.scss";

const SamplePreviewTable = (props) => {
    const { data } = props;

    const stringifyValue = (value) => {
        if (typeof value === "object") {
            return JSON.stringify(value, null, "  ");
        } else {
            return "" + value;
        }
    };

    const colNames = !isEmpty(data) ? Object.keys(data[0]) : [];

    return (
        <div>
            <table className="SamplesViewsTable">
                <tbody>
                    <tr className="SamplesViewsTableHeader">
                        {colNames.map((name) => (
                            <th key={name}>{name}</th>
                        ))}
                    </tr>
                    {data.map((row, index) => (
                        <tr key={index} className="SamplesViewsTableRow">
                            {colNames.map((col, colIndex) => (
                                <td key={colIndex}>{stringifyValue(row[col])}</td>
                            ))}
                        </tr>
                    ))}
                </tbody>
            </table>
        </div>
    );
};

const SampleViewTableModal = connect((state) => ({
    visible: getSamplesState(state).modals.tableView,
    path: getSamplesState(state).modals.path,
    loaded: getSamplesState(state).loadedSamplePreview,
    preview: getSamplesState(state).samplePreview,
    failed: getSamplesState(state).failedSamplePreview,
}))((props) => {
    const { visible, path, loaded, failed, preview } = props;

    const { t } = useTranslation("samples");

    const dispatch = useDispatch();

    return (
        <div>
            <Modal theme="normal" onClose={() => dispatch(closeSampleTableView())} visible={visible}>
                {visible && (
                    <div className="SampleViewTable">
                        <div className="SampleViewTable-header">
                            <div className="SampleViewTable-header-name">{path}</div>
                        </div>
                        <div className="SampleViewTable-content">
                            <Failable failed={failed} errorMessage={failed ? t("error.failedToLoadPreview") : ""}>
                                <div className="AudiencesLayoutBody">
                                    <Failable failed={isEmpty(preview) && loaded} errorMessage={t("error.noData")}>
                                        <Loading loaded={loaded}>
                                            <SamplePreviewTable data={preview} />
                                        </Loading>
                                    </Failable>
                                </div>
                            </Failable>
                        </div>
                    </div>
                )}
            </Modal>
        </div>
    );
});

export default SampleViewTableModal;
