import React from "react";
import { useTranslation } from "react-i18next";
import { Button, RadioButton } from "@lib/components/lego";
import CreateSampleModal from "./CreateSampleModal";
import CreateDatedSampleModal from "../predictive_analytics/components/CreateDatedSampleModal";
import FontAwesome from "react-fontawesome";
import { connect, useDispatch } from "react-redux";
import { getSamplesState } from "./selectors";
import { selectType, openSampleCreateModal } from "./actions";

import "./SamplesMenu.scss";

const SamplesMenu = connect((state) => ({
    type: getSamplesState(state).type,
    sampleModalVisible: getSamplesState(state).modals.sampleCreate,
}))((props) => {
    const { type, sampleModalVisible, dated } = props;

    const dispatch = useDispatch();
    const { t } = useTranslation("samples");

    return (
        <div className="Samples-menu">
            <div className="Samples-menuInternal">
                <RadioButton
                    value={type}
                    view="default"
                    size="s"
                    onChange={(event) => dispatch(selectType(event.target.value))}
                    options={[
                        { value: "my", children: t("menu.my") },
                        { value: "common", children: t("menu.common") },
                        { value: "viewed", children: t("menu.viewed") },
                    ]}
                />
                <Button
                    view="action"
                    theme="action"
                    size="s"
                    title={t("menu.createSample")}
                    onClick={() => dispatch(openSampleCreateModal())}
                >
                    <FontAwesome name="plus" />
                </Button>
                {sampleModalVisible && (dated ? <CreateDatedSampleModal /> : <CreateSampleModal />)}
            </div>
        </div>
    );
});

export default SamplesMenu;
