import React from "react";
import { connect, useDispatch } from "react-redux";
import { useTranslation } from "react-i18next";
import { Modal } from "@lib/components/lego";

import LabModalHeader from "../utils/LabModalHeader";
import { closeSiberiaSampleView } from "src/samples/actions";
import SiberiaSegmentCreation from "src/samples/SiberiaSegmentCreation";
import SiberiaSegmentsList from "src/samples/SiberiaSegmentsList";
import SiberiaUsersPage from "src/samples/SiberiaUsersPage";

import { getSamplesState } from "src/selectors";

import "./SiberiaSampleViewModal.scss";

const SiberiaSampleViewModal = connect((state) => ({
    visible: getSamplesState(state).modals.siberiaView,
}))((props) => {
    const { sample, visible } = props;

    const dispatch = useDispatch();
    const { t, i18n } = useTranslation("siberia");

    const lang = i18n.language;

    const close = () => dispatch(closeSiberiaSampleView());

    return (
        <div>
            <Modal theme="normal" onClose={close} visible={visible}>
                <LabModalHeader
                    title={sample ? sample.name : "—"}
                    info={`user_set_id:${sample ? sample.siberiaUserSetId : "—"}`}
                    hasClose
                    onClose={close}
                />
                {visible && (
                    <div className="SiberiaSampleView-container">
                        <div>
                            <SiberiaSegmentCreation siberiaUserSetId={sample.siberiaUserSetId} lang={lang} />
                        </div>
                        <div>
                            <SiberiaSegmentsList userSetId={sample.siberiaUserSetId} lang={lang} />
                        </div>
                        <div>
                            <div className="SiberiaSampleView-content">
                                <h2>{t("users")}</h2>
                                <SiberiaUsersPage userSetId={sample.siberiaUserSetId} lang={lang} />
                            </div>
                        </div>
                    </div>
                )}
            </Modal>
        </div>
    );
});

export default SiberiaSampleViewModal;
