import React, { useState } from "react";
import { connect, useDispatch } from "react-redux";
import { useTranslation } from "react-i18next";
import { Button, TextInput } from "@lib/components/lego";
import Loading from "@lib/components/loading";

import {
    createSiberiaSegment,
    setSiberiaSegmentCreationTitle,
    setSiberiaSegmentCreationRule,
} from "src/samples/actions";

import { getApiState, getSiberiaSegmentsState } from "src/selectors";

import "./SiberiaSegmentCreation.scss";

const SiberiaSegmentCreation = connect((state) => ({
    api: getApiState(state),
    title: getSiberiaSegmentsState(state).creationFields.title,
    rule: getSiberiaSegmentsState(state).creationFields.rule,
}))((props) => {
    const { api, siberiaUserSetId, title, rule } = props;

    const dispatch = useDispatch();
    const { t } = useTranslation("siberia");

    const [error, setError] = useState(null);
    const [loaded, setLoaded] = useState(true);

    const initialize = () => {
        setError(null);
        setLoaded(true);
    };

    const createSiberiaSegment_ = (api, params, onError, onSuccess) =>
        dispatch(createSiberiaSegment(api, params, onError, onSuccess));

    const handleError = (error) => {
        setLoaded(true);
        setError(error);
    };

    const handleSuccess = () => {
        initialize();
    };

    const handleChangeTitle = (title) => dispatch(setSiberiaSegmentCreationTitle(title));
    const handleChangeRule = (rule) => dispatch(setSiberiaSegmentCreationRule(rule));

    const createSegment = () => {
        setError(null);
        setLoaded(false);

        createSiberiaSegment_(
            api,
            { user_set_id: siberiaUserSetId, title: title, rule: rule },
            handleError,
            handleSuccess
        );
    };

    return (
        <Loading loaded={loaded}>
            <span className="SiberiaSegmentCreation-inputs">
                <span className="SiberiaSegmentCreation-title">
                    <TextInput
                        view="default"
                        theme="normal"
                        size="m"
                        value={title}
                        onChange={(event) => handleChangeTitle(event.target.value)}
                        placeholder={t("namePlaceholder")}
                    />
                </span>
                <span className="SiberiaSegmentCreation-rule">
                    <TextInput
                        view="default"
                        theme="normal"
                        size="m"
                        value={rule}
                        onChange={(event) => handleChangeRule(event.target.value)}
                        placeholder={t("rulePlaceholder")}
                    />
                </span>

                <Button view="action" theme="action" size="m" onClick={createSegment}>
                    {t("createSegment")}
                </Button>
            </span>

            {error && (
                <div className="SiberiaSegmentCreation-error">{(error.obj && error.obj.errors) || error.data}</div>
            )}
        </Loading>
    );
});

export default SiberiaSegmentCreation;
