import React from "react";
import { connect } from "react-redux";
import FontAwesome from "react-fontawesome";

import {
    getSiberiaSegmentUsers,
    fetchSiberiaSample,
    removeSiberiaSegment,
    selectSiberiaSegment,
    setSiberiaSegmentCreationRule,
    setSiberiaSegmentCreationTitle,
} from "src/samples/actions";

import { getApiState, getSamplesState, getSelectedSiberiaSegmentIdState } from "src/selectors";

import "src/samples/SiberiaSegmentView.scss";

@connect(
    (state) => ({
        api: getApiState(state),
        selectedSiberiaSegmentId: getSelectedSiberiaSegmentIdState(state),
    }),
    (dispatch) => ({
        removeSiberiaSegment: (api, userSetId, segmentId, onError) =>
            dispatch(removeSiberiaSegment(api, userSetId, segmentId, onError)),
        selectSiberiaSegment: (segment) => dispatch(selectSiberiaSegment(segment)),
        setSiberiaSegmentCreationTitle: (title) => dispatch(setSiberiaSegmentCreationTitle(title)),
        setSiberiaSegmentCreationRule: (rule) => dispatch(setSiberiaSegmentCreationRule(rule)),
        getSiberiaSegmentUsers: (api, userSetId, segmentId) =>
            dispatch(getSiberiaSegmentUsers(api, userSetId, segmentId)),
        getSiberiaUserSetUsers: (api, userSetId) => dispatch(fetchSiberiaSample(api, userSetId)),
    })
)
class SiberiaSegmentView extends React.Component {
    constructor() {
        super();
        this.remove = this.remove.bind(this);
        this.handleError = this.handleError.bind(this);
        this.handleClick = this.handleClick.bind(this);
        this.getBodyClassName = this.getBodyClassName.bind(this);
        this.isSelected = this.isSelected.bind(this);

        this.state = {
            error: null,
        };
    }

    remove() {
        this.setState({ error: null }, () => {
            this.props.removeSiberiaSegment(
                this.props.api,
                this.props.userSetId,
                this.props.segment.Id,
                this.handleError
            );
        });
    }

    handleError(error) {
        this.setState({ error: error });
    }

    isSelected() {
        return this.props.segment.Id == this.props.selectedSiberiaSegmentId;
    }

    handleClick() {
        if (this.isSelected()) {
            this.props.selectSiberiaSegment(null);
            this.props.setSiberiaSegmentCreationTitle("");
            this.props.setSiberiaSegmentCreationRule("");
            this.props.getSiberiaUserSetUsers(this.props.api, this.props.userSetId);
        } else {
            this.props.selectSiberiaSegment(this.props.segment);
            this.props.setSiberiaSegmentCreationTitle(this.props.segment.Title);
            this.props.setSiberiaSegmentCreationRule(this.props.segment.Rule);
            this.props.getSiberiaSegmentUsers(this.props.api, this.props.userSetId, this.props.segment.Id);
        }
    }

    getBodyClassName() {
        var classes = ["siberia-segment-view-body"];

        if (this.isSelected()) {
            classes.push("siberia-segment-view-selected");
        }

        return classes.join(" ");
    }

    render() {
        return (
            <div className={this.getBodyClassName()}>
                <div className="siberia-segment-view-remove-button">
                    <FontAwesome key="remove" name="remove" onClick={this.remove} />
                </div>

                <div className="siberia-segment-view-box" onClick={this.handleClick}>
                    <pre className="siberia-segment-view-json">{JSON.stringify(this.props.segment, null, 2)}</pre>
                </div>

                {this.state.error && <div className="siberia-segment-view-error">{this.state.error.data}</div>}
            </div>
        );
    }
}

export default SiberiaSegmentView;
