import React from "react";
import { connect } from "react-redux";
import { isEmpty as _isEmpty, get as _get } from "lodash";
import Loading from "@lib/components/loading";
import { fetchSiberiaSegments } from "src/samples/actions";
import SiberiaSegmentView from "src/samples/SiberiaSegmentView";

import { getApiState, getSiberiaSegmentsState } from "src/selectors";
import Failable from "src/utils/Failable";
import Refresh from "src/utils/Refresh";

import "src/samples/SiberiaSegmentsList.scss";

@connect(
    (state) => ({
        api: getApiState(state),

        error: getSiberiaSegmentsState(state).error,
        loaded: !getSiberiaSegmentsState(state).loading && !getSiberiaSegmentsState(state).removing,
        segments: getSiberiaSegmentsState(state).data,
    }),
    (dispatch) => ({
        getSiberiaSegments: (api, userSetId) => dispatch(fetchSiberiaSegments(api, userSetId)),
    })
)
class SiberiaSegmentsList extends React.Component {
    constructor() {
        super();

        this.getSiberiaSegments = this.getSiberiaSegments.bind(this);
    }

    getSiberiaSegments() {
        this.props.getSiberiaSegments(this.props.api, this.props.userSetId);
    }

    componentDidMount() {
        this.getSiberiaSegments();
    }

    render() {
        let renderSegment = (segment) => {
            return (
                <div key={segment.Id}>
                    <SiberiaSegmentView userSetId={this.props.userSetId} segment={segment} lang={this.props.lang} />
                </div>
            );
        };

        return (
            <div>
                <Loading loaded={this.props.loaded}>
                    <div>
                        <Refresh action={this.getSiberiaSegments} />
                    </div>
                    <Failable
                        failed={this.props.error !== null}
                        errorMessage={_isEmpty(this.props.error) ? "" : _get(this.props.error.message, this.props.lang)}
                    >
                        <div className="siberia-segments-list-box">
                            {this.props.segments && this.props.segments.map(renderSegment)}
                        </div>
                    </Failable>
                </Loading>
            </div>
        );
    }
}

export default SiberiaSegmentsList;
