import React, { useEffect } from "react";
import { connect, useDispatch } from "react-redux";
import { isEmpty as _isEmpty, get as _get } from "lodash";
import { useTranslation } from "react-i18next";
import { Button } from "@lib/components/lego";
import Loading from "@lib/components/loading";

import { fetchSiberiaSample, getSiberiaSegmentUsers } from "src/samples/actions";

import { getApiState, getSamplesState, getSelectedSiberiaSegmentIdState } from "src/selectors";
import Failable from "src/utils/Failable";

import "./SiberiaUsersPage.scss";

const SiberiaUsersPage = connect((state) => ({
    api: getApiState(state),
    users: getSamplesState(state).siberiaSample,
    selectedSegmentId: getSelectedSiberiaSegmentIdState(state),
    loaded: getSamplesState(state).loadedSiberiaSample,
    error: getSamplesState(state).errorSiberiaSample,
}))((props) => {
    const { api, users, selectedSegmentId, userSetId, loaded, error } = props;

    const dispatch = useDispatch();
    const { t, i18n } = useTranslation("siberia");
    const lang = i18n.language;

    const getSiberiaUserSetUsers = (api, userSetId, lastUserId) =>
        dispatch(fetchSiberiaSample(api, userSetId, lastUserId));
    const getSiberiaSegmentUsers_ = (api, userSetId, segmentId, lastUserId) =>
        dispatch(getSiberiaSegmentUsers(api, userSetId, segmentId, lastUserId));

    const getUsers = (lastUserId) => {
        if (selectedSegmentId !== null) {
            getSiberiaSegmentUsers_(api, userSetId, selectedSegmentId, lastUserId);
        } else {
            getSiberiaUserSetUsers(api, userSetId, lastUserId);
        }
    };

    const nextPage = () => {
        let lastUserId = users && users.length !== 0 ? users[users.length - 1].Id : null;

        getUsers(lastUserId);
    };

    useEffect(() => {
        nextPage();
    }, []);

    return (
        <Failable failed={error !== null} errorMessage={_isEmpty(error) ? "" : _get(error.message, lang)}>
            <Loading loaded={loaded}>
                {users && <PageTable data={users.map((item) => item.Info.Attributes)} />}

                <div className="siberia-users-page-buttons">
                    <span className="siberia-users-page-button">
                        <Button view="action" theme="action" size="s" onClick={() => getUsers(null)}>
                            {t("startOver")}
                        </Button>
                    </span>
                    <span className="siberia-users-page-button">
                        <Button view="action" theme="action" size="s" onClick={nextPage}>
                            {t("nextPage")}
                        </Button>
                    </span>
                </div>
            </Loading>
        </Failable>
    );
});

const PageTable = (props) => {
    const { data } = props;
    const colNames = Object.keys(data[0]).sort();

    return (
        <div>
            <table className="siberia-users-page-table">
                <tbody>
                    <tr className="siberia-users-page-table-header">
                        {colNames.map((name) => (
                            <th key={name}>{name}</th>
                        ))}
                    </tr>
                    {data.map((row, index) => (
                        <tr key={index} className="siberia-users-page-table-row">
                            {colNames.map((col, colIndex) => (
                                <td key={colIndex}>{row[col].Values}</td>
                            ))}
                        </tr>
                    ))}
                </tbody>
            </table>
        </div>
    );
};

export default SiberiaUsersPage;
