import {
    changeSampleType,
    updateBaseType,
    closeSampleCreateModal,
    closeSampleInfo,
    closeSampleStats,
    closeSampleTableView,
    closeSampleViews,
    closeSiberiaSampleView,
    failCreateView,
    failedBaseSample,
    failedSamplePreview,
    failedSamples,
    failedSampleStats,
    failedSampleViews,
    failedSiberiaSampleView,
    failedSiberiaSegments,
    failSiberiaSegmentRemoving,
    failSubsamples,
    openSampleCreateModal,
    openSampleInfo,
    openSampleStats,
    openSampleTableView,
    openSampleViews,
    openSiberiaSampleView,
    receiveBaseSample,
    receiveSamplePreview,
    receiveSamples,
    receiveSampleStats,
    receiveSampleViews,
    receiveSiberiaSampleView,
    receiveSiberiaSegments,
    receiveSubsamples,
    requestBaseSample,
    requestCreateView,
    requestSamplePreview,
    requestSamples,
    requestSampleStats,
    requestSampleViews,
    requestSiberiaSampleView,
    requestSiberiaSegmentRemoving,
    requestSiberiaSegments,
    requestSubsamples,
    selectSampleGroup,
    selectSiberiaSegment,
    setSampleStatsNotFound,
    setSampleStatsNotReady,
    setSiberiaSegmentCreationRule,
    setSiberiaSegmentCreationTitle,
    successCreateView,
    successSiberiaSegmentRemoving,
} from "actions";
import {
    receiveSiberiaSampleStats,
    requestSiberiaSampleStats,
    setSiberiaSampleStatsNotFound,
    setSiberiaSampleStatsNotReady,
    failedSiberiaSampleStats,
    failedExportUserSetId,
} from '../stats/actions';
import { handleActions } from "redux-actions";
import _ from "lodash";
import { setCreateSampleViewFormVisibility } from "./actions";

function obtainMessage(error) {
    if (_.isString(error)) {
        return error;
    }
    if (_.isObject(error)) {
        if (error.obj) {
            return error.obj.message || "Unknown error";
        } else {
            return error;
        }
    }
}

export const samplesReducer = handleActions(
    {
        [requestSamples]: (state) => ({
            ...state,
            loaded: false,
            failed: false,
        }),
        [receiveSamples]: (state, { payload }) => ({
            ...state,
            samples: payload,
            loaded: true,
            failed: false,
        }),
        [failedSamples]: (state, { payload }) => ({
            ...state,
            failed: true,
            message: obtainMessage(payload),
        }),
        [requestSampleViews]: (state) => ({
            ...state,
            loadedViews: false,
            failedViews: false,
        }),
        [receiveSampleViews]: (state, { payload }) => ({
            ...state,
            views: payload,
            loadedViews: true,
            failedViews: false,
        }),
        [failedSampleViews]: (state) => ({
            ...state,
            failedViews: true,
        }),
        [requestBaseSample]: (state) => ({
            ...state,
            baseSample: {
                value: [],
                loading: true,
                error: false,
            },
        }),
        [receiveBaseSample]: (state, { payload }) => ({
            ...state,
            baseSample: {
                value: payload,
                loading: false,
                error: false,
            },
        }),
        [failedBaseSample]: (state) => ({
            ...state,
            baseSample: {
                value: [],
                loading: false,
                error: true,
            },
        }),
        [updateBaseType]: (state) => ({
            ...state,
            baseSample: {},
            errorBaseStats: null,
        }),
        [openSampleStats]: (state) => ({
            ...state,
            modals: { ...state.modals, stats: true },
        }),
        [closeSampleStats]: (state) => ({
            ...state,
            siberiaSampleStats: null,
            modals: { ...state.modals, stats: false },
        }),
        [openSampleInfo]: (state) => ({
            ...state,
            modals: { ...state.modals, info: true },
        }),
        [closeSampleInfo]: (state) => ({
            ...state,
            modals: { ...state.modals, info: false },
        }),
        [openSampleViews]: (state) => ({
            ...state,
            modals: { ...state.modals, views: true },
        }),
        [closeSampleViews]: (state) => ({
            ...state,
            modals: { ...state.modals, views: false },
        }),
        [openSampleTableView]: (state, { payload }) => ({
            ...state,
            modals: { ...state.modals, tableView: true, path: payload },
        }),
        [closeSampleTableView]: (state) => ({
            ...state,
            modals: { ...state.modals, tableView: false, path: "" },
        }),
        [openSiberiaSampleView]: (state) => ({
            ...state,
            modals: { ...state.modals, siberiaView: true },
        }),
        [closeSiberiaSampleView]: (state) => ({
            ...state,
            siberiaSegmentsState: {
                ...state.siberiaSegmentsState,
                selected: null,
                rule: "",
            },
            modals: { ...state.modals, siberiaView: false },
        }),
        [openSampleCreateModal]: (state) => ({
            ...state,
            modals: { ...state.modals, sampleCreate: true },
        }),
        [closeSampleCreateModal]: (state) => ({
            ...state,
            modals: { ...state.modals, sampleCreate: false },
        }),
        [setCreateSampleViewFormVisibility]: (state, { payload }) => ({
            ...state,
            createSampleViewFormVisible: payload,
        }),
        [changeSampleType]: (state, { payload }) => ({
            ...state,
            type: payload,
        }),

        [requestSubsamples]: (state) => ({
            ...state,
            subsamples: {
                loading: true,
                value: {},
                error: false,
            },
        }),
        [receiveSubsamples]: (state, { payload }) => ({
            ...state,
            subsamples: {
                loading: false,
                value: payload,
                error: false,
            },
        }),
        [failSubsamples]: (state) => ({
            ...state,
            subsamples: {
                loading: false,
                value: {},
                error: true,
            },
        }),

        [requestSampleStats]: (state) => ({
            ...state,
            loadedStats: false,
            stats: {},
            errorStats: false,
            sampleStatsNotFound: false,
        }),
        [receiveSampleStats]: (state, { payload }) => ({
            ...state,
            loadedStats: true,
            stats: payload,
            errorStats: false,
            sampleStatsNotReady: !payload.ready,
        }),
        [failedSampleStats]: (state, { payload }) => {
            let error = payload;
            if (error.status === 400 && error.response.obj.message === "Sample is too small") {
                return {
                    ...state,
                    errorStats: true,
                };
            } else {
                return {
                    ...state,
                    errorStats: true,
                    errorStatsRetriable: true,
                };
            }
        },
        [setSampleStatsNotFound]: (state) => ({
            ...state,
            sampleStatsNotFound: true,
        }),
        [setSampleStatsNotReady]: (state) => ({
            ...state,
            sampleStatsNotReady: true,
        }),
        [selectSampleGroup]: (state, { payload }) => ({
            ...state,
            selectedGroup: payload,
        }),
        [requestCreateView]: (state) => ({
            ...state,
            creatingView: true,
            creatingViewErrorCode: null,
        }),
        [successCreateView]: (state) => ({
            ...state,
            creatingView: false,
            creatingViewErrorCode: null,
        }),
        [failCreateView]: (state, { payload }) => ({
            ...state,
            creatingView: false,
            creatingViewErrorCode: payload,
        }),
        [requestSamplePreview]: (state) => ({
            ...state,
            loadedSamplePreview: false,
            failedSamplePreview: false,
        }),
        [receiveSamplePreview]: (state, { payload }) => ({
            ...state,
            loadedSamplePreview: true,
            samplePreview: payload,
            failedSamplePreview: false,
        }),
        [failedSamplePreview]: (state) => ({
            ...state,
            loadedSamplePreview: true,
            samplePreview: null,
            failedSamplePreview: true,
        }),
        [requestSiberiaSampleView]: (state) => ({
            ...state,
            loadedSiberiaSample: false,
            errorSiberiaSample: null,
        }),
        [receiveSiberiaSampleView]: (state, { payload }) => ({
            ...state,
            loadedSiberiaSample: true,
            siberiaSample: payload.Users,
        }),
        [failedSiberiaSampleView]: (state, { payload }) => ({
            ...state,
            loadedSiberiaSample: true,
            siberiaSample: null,
            errorSiberiaSampleMessage: {
                value: payload,
                message: {
                    en: "Unable to load sample from Siberia",
                    ru: "Не удалось загрузить выборку из Сибири",
                },
            },
        }),
        [requestSiberiaSampleStats]: (state) => ({
            ...state,
            loadedSiberiaSampleStats: false,
            errorSiberiaSampleStats: null,
            errorBaseStats: null,
            notReady: false,
            siberiaSampleStatsNotFound: false,
        }),
        [receiveSiberiaSampleStats]: (state, { payload }) => ({
            ...state,
            loadedSiberiaSampleStats: true,
            siberiaSampleStats: payload,
        }),
        [failedSiberiaSampleStats]: (state) => ({
            ...state,
            loadedSiberiaSampleStats: true,
            siberiaSampleStats: null,
            errorSiberiaSampleStats: true,
            errorBaseStats: null,
        }),
        [setSiberiaSampleStatsNotReady]: (state) => ({
            ...state,
            siberiaSampleStats: null,
            notReady: true,
        }),
        [setSiberiaSampleStatsNotFound]: (state) => ({
            ...state,
            siberiaSampleStatsNotFound: true,
        }),
        [failedExportUserSetId]: (state) => ({
            ...state,
            errorBaseStats: true,
        }),
        [requestSiberiaSegments]: (state) => ({
            ...state,
            siberiaSegmentsState: {
                ...state.siberiaSegmentsState,
                loading: true,
                error: null,
                data: [],
            },
        }),
        [receiveSiberiaSegments]: (state, { payload }) => ({
            ...state,
            siberiaSegmentsState: {
                ...state.siberiaSegmentsState,
                loading: false,
                error: null,
                data: payload.Segments,
            },
        }),
        [failedSiberiaSegments]: (state, { payload }) => ({
            ...state,
            siberiaSegmentsState: {
                ...state.siberiaSegmentsState,
                loading: false,
                error: {
                    value: payload,
                    message: {
                        en: "Unable to load segments from Siberia",
                        ru: "Не удалось загрузить сегменты из Сибири",
                    },
                },
                data: [],
            },
        }),
        [selectSiberiaSegment]: (state, { payload }) => ({
            ...state,
            siberiaSegmentsState: {
                ...state.siberiaSegmentsState,
                selected: payload,
            },
        }),
        [setSiberiaSegmentCreationTitle]: (state, { payload }) => ({
            ...state,
            siberiaSegmentsState: {
                ...state.siberiaSegmentsState,
                creationFields: {
                    ...state.siberiaSegmentsState.creationFields,
                    title: payload,
                },
            },
        }),
        [setSiberiaSegmentCreationRule]: (state, { payload }) => ({
            ...state,
            siberiaSegmentsState: {
                ...state.siberiaSegmentsState,
                creationFields: {
                    ...state.siberiaSegmentsState.creationFields,
                    rule: payload,
                },
            },
        }),
        [requestSiberiaSegmentRemoving]: (state) => ({
            ...state,
            siberiaSegmentsState: {
                ...state.siberiaSegmentsState,
                removing: true,
            },
        }),
        [successSiberiaSegmentRemoving]: (state) => ({
            ...state,
            siberiaSegmentsState: {
                ...state.siberiaSegmentsState,
                removing: false,
            },
        }),
        [failSiberiaSegmentRemoving]: (state) => ({
            ...state,
            siberiaSegmentsState: {
                ...state.siberiaSegmentsState,
                removing: false,
            },
        }),
    },
    {
        loaded: false,
        type: "my",
        modals: {},
        samples: { my: [], common: [], viewed: [] },
        siberiaSample: null,
        siberiaSegmentsState: {
            loading: false,
            removing: false,
            error: null,
            data: [],
            selected: null,
            creationFields: {
                title: "",
                rule: "",
            },
        },

        creatingViewErrorCode: null,
        subsamples: {},
        baseSample: {},
        selectedGroup: "",
    }
);
