import { createSelector } from "reselect";
import { invert as _invert } from "lodash";
import qs from "query-string";

const getSamples = (state) => state.samples;
export const getSamplesState = createSelector([getSamples], (data) => data);

const getLocation = (state) => state.router.location;
const searchSampleIdCombiner = (location) => qs.parse(location.search).sample;
export const getSelectedSampleIdState = createSelector([getLocation], searchSampleIdCombiner);

const _getSiberiaSegmentsState = (state) => getSamples(state).siberiaSegmentsState;
export const getSiberiaSegmentsState = createSelector([_getSiberiaSegmentsState], (data) => data);
export const getSelectedSiberiaSegmentIdState = createSelector([_getSiberiaSegmentsState], (data) =>
    data.selected ? data.selected.Id : null
);

const getSubsamples = (state) => getSamples(state).subsamples;
export const getSubsamplesState = createSelector(getSubsamples, (data) => data);
export const getSubsampleDictState = createSelector(getSubsamples, (subsamples) => {
    return subsamples.value ? _invert(subsamples.value.userSetIdToGroupingKeyValue) : {};
});

export const getSelectedSampleState = createSelector([getLocation, getSamples], (location, samples) => {
    const sampleId = searchSampleIdCombiner(location);
    return samples.samples[samples.type].filter((each) => each.id === sampleId)[0];
});

export const getSelectedGroupState = createSelector(
    (state) => state.samples.selectedGroup,
    (data) => data
);
