import React, { useCallback, useState } from "react";
import { connect } from "react-redux";
import { debounce, isEmpty } from "lodash";
import Link from "@lib/components/link";

import { getSelectedSampleState } from "../selectors";
import { closeSampleStats, selectSampleGroup } from "../actions";
import GroupSuggest from "../../stats/group-suggest";

import sandboxPic from "src/images/sandbox.png";

import "./style.scss";

const SANDBOX_TASK_BASE_URL = "https://sandbox.yandex-team.ru/tasks/?tags=";

const SampleStatsModalHeader = connect((state) => ({
    sample: getSelectedSampleState(state),
}))((props) => {
    const { sample, dispatch } = props;

    const [searchText, setSearchText] = useState("");

    const close = () => {
        dispatch(closeSampleStats());
    };

    const _changeInput = useCallback(
        debounce((group) => dispatch(selectSampleGroup(group)), 500),
        []
    );

    const selectGroup = (group) => {
        dispatch(selectSampleGroup(group));
    };

    const changeGroup = (group) => {
        setSearchText(group);
        _changeInput(group);
    };

    const hasGroups = !isEmpty(sample.userSetIdToGroupingKeyValue);

    return (
        <div className="SampleStatsModalHeader">
            <span className="SampleStatsModalHeader-left">
                <span className="SampleStatsModalHeader-name">{sample.name}</span>
                {hasGroups && (
                    <span>
                        <span className="Delimiter">/</span>
                        <GroupSuggest
                            sampleGroups={Object.values(sample.userSetIdToGroupingKeyValue)}
                            activeGroup={searchText}
                            onSuggestionSelected={selectGroup}
                            onChange={changeGroup}
                        />
                    </span>
                )}
            </span>

            <span className="SampleStatsModalHeader-right">
                <Link href={SANDBOX_TASK_BASE_URL + sample.id} target="_blank">
                    <img alt="Sandbox" className="SandboxLink" src={sandboxPic} />
                </Link>
                <span className="SampleStatsModal-close" onClick={close}>
                    ⨉
                </span>
            </span>
        </div>
    );
});

export default SampleStatsModalHeader;
