import React from "react";
import { connect } from "react-redux";
import { isEmpty } from "lodash";
import { useTranslation } from "react-i18next";

import { Spin } from "@lib/components/lego";
import SampleStats from "@lib/stats/SampleStats";

import StatsNotReady from "../../stats/StatsNotReady";

import {
    getSamplesState,
    getSelectedGroupState,
    getSelectedSampleState,
} from "../selectors";

import "../../stats/style.scss";

const SiberiaSampleStats = connect((state) => ({
    sample: getSelectedSampleState(state),
    stats: getSamplesState(state).siberiaSampleStats,
    group: getSelectedGroupState(state),
    loaded: getSamplesState(state).loadedSiberiaSampleStats,
    failed: getSamplesState(state).errorSiberiaSampleStats,
    notReady: getSamplesState(state).notReady,
    notFound: getSamplesState(state).siberiaSampleStatsNotFound,
}))((props) => {
    const { sample, stats, group, loaded, failed, notReady, notFound, subsamples } = props;

    const { t } = useTranslation("stats");

    const exportFileBasename = !isEmpty(group) ? sample.id + "_" + group : sample.id;

    const groupSelected = Object.keys(subsamples).length === 0 ? true : !isEmpty(group);
    const statsNotReady = loaded && groupSelected && notReady;

    return (
        <div className="Stats">
            {!groupSelected ? (
                <div className="Stats-loading-status">
                    {t("subsamplePlaceholder")}
                </div>
            ) : <div></div>}
            {(!loaded && !failed && groupSelected) && (
                <div className="Stats-loading-status">
                    <Spin progress={true} view="default" size="l" />
                </div>
            )}
            {statsNotReady && (
                <div className="Stats-loading-status">
                    <StatsNotReady reloadFunc={fetch} />
                </div>
            )}
            {notFound && <div className="Stats-loading-status">{t("notFound")}</div>}
            {loaded && !statsNotReady && stats && (
                <SampleStats
                    loaded={loaded}
                    stats={{
                        value: stats.Stats,
                        ready: stats.Info.Ready,
                    }}
                    exportFileBasename={exportFileBasename}
                    withLoading={false}
                />
            )}
        </div>
    );
});

export default SiberiaSampleStats;
