import React, {useEffect, useState} from "react";
import { connect } from "react-redux";
import { isUndefined, isEmpty, invert as _invert } from "lodash";

import { Modal } from "@lib/components/lego";

import { getSamplesState, getSelectedSampleState, getSelectedGroupState } from "../selectors";
import { getApiState } from "../../selectors";
import { fetchSiberiaSampleStats, fetchSiberiaSampleStatsByExportId } from "../../stats/actions";
import { closeSampleStats } from "../actions";
import SiberiaSampleStats from "./SiberiaSampleStats";
import SampleStatsModalHeader from "./SampleStatsModalHeader";
import BaseStatsParams from "../../stats/BaseStatsParams";

import "../../stats/style.scss";

const SampleStatsModal_ = connect((state) => ({
    api: getApiState(state),
    visible: getSamplesState(state).modals.stats,
    sample: getSelectedSampleState(state),
    group: getSelectedGroupState(state),
}))((props) => {
    const { api, visible, sample, group, dispatch } = props;

    const close = () => dispatch(closeSampleStats());
    const [siberiaUserSetId, setSiberiaUserSetId] = useState(null);

    const subsamples = sample ? _invert(sample.userSetIdToGroupingKeyValue) : {};

    useEffect(() => {
        console.log(siberiaUserSetId);
        if (!isEmpty(sample) && visible && siberiaUserSetId) {
            dispatch(fetchSiberiaSampleStats(api, siberiaUserSetId));
        }
    }, [siberiaUserSetId]);

    useEffect(() => {
        if (!visible) {
            setSiberiaUserSetId(null);
        } else {
            setSiberiaUserSetId(!isUndefined(sample) && (!isEmpty(subsamples) ? subsamples[group] : sample.siberiaUserSetId));
        }
    }, [group, sample, visible]);


    return (
        !isEmpty(sample) && (
            <Modal theme="normal" visible={visible} hasAnimation={false} onClose={close} autoFocus={false}>
                <div className="StatsModal">
                    <SampleStatsModalHeader />
                    <BaseStatsParams
                        fetchStats={() => fetchSiberiaSampleStats(api, siberiaUserSetId)}
                        fetchStatsBySample={
                            (baseId, baseGroup, baseSetId) => fetchSiberiaSampleStats(api, siberiaUserSetId, baseSetId)
                        }
                        fetchStatsByExport={
                            (baseID) => fetchSiberiaSampleStatsByExportId(api, siberiaUserSetId, baseID)
                        }
                    />
                    <SiberiaSampleStats subsamples={subsamples}/>
                </div>
            </Modal>
        )
    );
});

export default SampleStatsModal_;
