import React from "react";
import { connect } from "react-redux";
import { getSegmentsTreeActiveRootState, getTriggerRerenderSegmentsState } from "./selectors";
import UserSegmentsList from "./user-segments";
import SegmentsList from "./segments-list";
import SegmentsTree, { SegmentsTreeNode } from "./tree";
import SearchOptions from "./filter";
import { getDisplayModeState } from "./filter/filterSelectors";

import "./style.scss";
import { DISPLAY_MODE } from "./filter/filterActions";
import { resetMatchSegmentConditions } from "./actions";

const DisplayedSegments = connect((state) => ({
    displayMode: getDisplayModeState(state),
    rootSegment: getSegmentsTreeActiveRootState(state),
    triggerRerenderSegments: getTriggerRerenderSegmentsState(state),
}))((props) => {
    // triggerRerenderSegments forces to rerender the component when search updates, do not remove
    const { displayMode, rootSegment, dispatch } = props;

    const segmentsTree = (
        <SegmentsTree>
            <SegmentsTreeNode segment={rootSegment} level={0} key={"root"} />
        </SegmentsTree>
    );

    const renderDisplayedSegments = () => {
        if (displayMode === DISPLAY_MODE.tree) {
            return segmentsTree;
        } else if (displayMode === DISPLAY_MODE.my) {
            dispatch(resetMatchSegmentConditions());
            return <UserSegmentsList />;
        } else if (displayMode === DISPLAY_MODE.filtered) {
            dispatch(resetMatchSegmentConditions());
            return <SegmentsList />;
        } else {
            return segmentsTree;
        }
    };

    return (
        <div className="DisplayedSegments">
            <SearchOptions />
            {renderDisplayedSegments()}
        </div>
    );
});

export default DisplayedSegments;
