import React, { useEffect } from "react";
import { connect, useDispatch } from "react-redux";
import { useTranslation } from "react-i18next";
import { Modal } from "@lib/components/lego";

import { fetchRule, hideRuleModal } from "./actions";
import {
    getApiState,
    getActiveRuleIdState,
    getActiveIdsState,
    getErrorState,
    getVisibleRuleModalState,
} from "../selectors";
import Rule from "./rule/index";
import Failable from "src/utils/Failable";

import "./RuleModal.scss";
import LabModalHeader from "../utils/LabModalHeader";
import { resetYtTableColumns } from "../utils/utilsActions";

const RuleModal = connect((state) => ({
    api: getApiState(state),
    exportId: getActiveIdsState(state).export, // FIXME To be removed
    ruleId: getActiveRuleIdState(state),
    visible: getVisibleRuleModalState(state),
    error: getErrorState(state),
}))((props) => {
    const { api, ruleId, visible, error, exportId } = props;

    const dispatch = useDispatch();
    const { t, i18n } = useTranslation("segments");
    const lang = i18n.language;

    const hideRule = () => {
        dispatch(hideRuleModal());
        dispatch(resetYtTableColumns());
    };

    useEffect(() => {
        if (ruleId) {
            dispatch(fetchRule(api, lang, ruleId));
        }
    }, []);

    return (
        <Modal theme="normal" visible={visible} onClose={hideRule}>
            <LabModalHeader title={t("rule.title")} hasClose onClose={hideRule} />
            <Failable failed={error} errorMessage={error.message}>
                <div className="RuleModal">
                    <div key="stats" className="RuleModal-main">
                        <Rule exportId={exportId} />
                    </div>
                </div>
            </Failable>
        </Modal>
    );
});

export default RuleModal;
