import React from "react";
import PropTypes from "prop-types";

import "./AudienceSegmentStatus.scss";

const PROCESSING = ["is_processed", "is_updated"];
const OK = ["processed"];
const ERROR = ["processing_failed", "few_data"];

const AudienceSegmentStatus = (props) => {
    const value = props.children;
    const status = props.status;

    if (typeof value !== "string") {
        return value;
    }

    let statusStyle;
    if (OK.includes(status)) {
        statusStyle = "ok";
    } else if (PROCESSING.includes(status)) {
        statusStyle = "processing";
    } else {
        statusStyle = "failed";
    }

    return (
        <span className="AudienceSegmentStatus">
            <div className={"AudienceSegmentStatus-" + statusStyle} />
            <span>{value}</span>
        </span>
    );
};

AudienceSegmentStatus.propTypes = {
    status: PropTypes.string.isRequired,
};

AudienceSegmentStatus.defaultProps = {
    status: "processed",
};

export default AudienceSegmentStatus;
