import { handleActions } from "redux-actions";
import {
    failAudienceSegment,
    failChangeSegmentName,
    failCreateGrant,
    failCreateManyGrants,
    failDeleteGrant,
    failGrants,
    invalidateCreatedGrants,
    invalidateDeletedGrants,
    receiveAudienceSegment,
    receiveChangeSegmentName,
    receiveCreateGrant,
    receiveCreateManyGrants,
    receiveDeleteGrant,
    receiveGrants,
    requestAudienceSegment,
    requestChangeSegmentName,
    requestCreateGrant,
    requestDeleteGrant,
    requestGrants,
} from "./audienceActions";

export const audiencesSegmentReducer = handleActions(
    {
        [requestAudienceSegment]: (state) => ({
            ...state,
            segment: {
                loading: true,
                value: null,
                error: false,
            },
        }),
        [receiveAudienceSegment]: (state, { payload }) => ({
            ...state,
            segment: {
                loading: false,
                value: payload,
                error: false,
            },
        }),
        [failAudienceSegment]: (state) => ({
            ...state,
            segment: {
                loading: false,
                value: null,
                error: true,
            },
        }),

        [requestGrants]: (state) => ({
            ...state,
            grants: {
                value: [],
                loading: true,
                error: false,
            },
        }),
        [receiveGrants]: (state, { payload }) => ({
            ...state,
            grants: {
                value: payload,
                loading: false,
                error: false,
            },
        }),
        [failGrants]: (state) => ({
            ...state,
            grants: {
                value: [],
                loading: false,
                error: true,
            },
        }),

        [requestCreateGrant]: (state, { payload }) => ({
            ...state,
            createdGrants: {
                [payload]: {
                    value: [],
                    loading: true,
                    error: null,
                },
            },
        }),
        [receiveCreateGrant]: (state, { payload }) => ({
            ...state,
            createdGrants: {
                ...state.createdGrants,
                [payload.requestedLogin]: {
                    loading: false,
                    value: payload.receivedLogin,
                    error: null,
                },
            },
        }),
        [failCreateGrant]: (state, { payload }) => ({
            ...state,
            createdGrants: {
                ...state.createdGrants,
                [payload.requestedLogin]: {
                    loading: false,
                    value: [],
                    error: payload.status,
                },
            },
        }),
        [receiveCreateManyGrants]: (state) => ({
            ...state,
            grants: {
                ...state.grants,
                loading: false,
                error: false,
            },
        }),
        [failCreateManyGrants]: (state) => ({
            ...state,
            grants: {
                ...state.grants,
                loading: false,
                error: true,
            },
        }),
        [invalidateCreatedGrants]: (state) => ({
            ...state,
            createdGrants: {},
            grants: {
                ...state.grants,
                loading: true,
            },
        }),

        [requestDeleteGrant]: (state, { payload }) => ({
            ...state,
            deletedGrants: {
                ...state.deletedGrants,
                [payload]: {
                    loading: true,
                    error: null,
                },
            },
        }),
        [receiveDeleteGrant]: (state, { payload }) => ({
            ...state,
            deletedGrants: {
                ...state.deletedGrants,
                [payload.userLogin]: {
                    loading: false,
                    error: null,
                },
            },
        }),
        [failDeleteGrant]: (state, { payload }) => ({
            ...state,
            deletedGrants: {
                ...state.deletedGrants,
                [payload]: {
                    loading: false,
                    error: true,
                },
            },
        }),
        [invalidateDeletedGrants]: (state) => ({
            ...state,
            deletedGrants: {},
        }),

        [requestChangeSegmentName]: (state) => ({
            ...state,
            name: {
                loading: true,
                result: null,
                error: false,
            },
        }),
        [receiveChangeSegmentName]: (state, { payload }) => ({
            ...state,
            name: {
                loading: false,
                result: payload,
                error: false,
            },
        }),
        [failChangeSegmentName]: (state) => ({
            ...state,
            name: {
                loading: false,
                result: null,
                error: true,
            },
        }),
    },
    {
        segment: {},
        grants: {
            value: [],
            loading: false,
            error: false,
        },
        createdGrants: {},
        deletedGrants: {},
        name: {
            loading: false,
            result: null,
            error: false,
        },
    }
);
