import { isUndefined } from "lodash";

export function prettifyNumber(num) {
    const million = 1000000;

    if (isUndefined(num)) {
        return "-";
    }

    if (num < million) {
        return num.toLocaleString("ru-RU");
    }

    return (num / million).toFixed(1).toLocaleString("ru-RU") + " M";
}
