import React, { useState } from "react";
import { isEmpty } from "lodash";
import { useTranslation } from "react-i18next";
import { Button, TextInput } from "@lib/components/lego";
import { getCurrentUserLogin } from "../../utils/cookie";
import { DEFAULT_USER_DOMAIN } from "../../utils/constants";

import "./style.scss";

const AT_SIGN = "@";

const AddUserPopup = (props) => {
    const { visible, addUserFunc, actionName } = props;

    const { t } = useTranslation("segments");

    const defaultLogin = getCurrentUserLogin();
    const [loginValue, setLoginValue] = useState(defaultLogin);

    const login = loginValue + AT_SIGN + DEFAULT_USER_DOMAIN;
    const isValid = !isEmpty(loginValue);

    const closeForm = () => {
        props.onOutsideClick();
        setLoginValue(defaultLogin);
    };

    const handleAddUser = () => {
        addUserFunc(login);
        closeForm();
    };

    return (
        <div className={"AddUserPopup-container" + (visible ? "" : "-hidden")}>
            <div className="AddUserPopup-form">
                <span className="AddUserPopup-login">
                    <TextInput
                        view="default"
                        theme="normal"
                        size="s"
                        value={loginValue}
                        placeholder={t("card.loginPlaceholder")}
                        onChange={(event) => setLoginValue(event.target.value)}
                    />
                </span>

                <span className="AddUserPopup-domain">
                    {AT_SIGN}
                    {DEFAULT_USER_DOMAIN}
                </span>
            </div>

            <div className="AddUserPopup-actions">
                <Button view="action" size="s" onClick={handleAddUser} disabled={!isValid} title={actionName}>
                    {actionName}
                </Button>

                <Button view="pseudo" size="s" onClick={closeForm} title={t("card.closeDialog")}>
                    {t("card.closeDialog")}
                </Button>
            </div>
        </div>
    );
};

export default AddUserPopup;
