import React from "react";
import { connect } from "react-redux";
import { isEmpty } from "lodash";
import { getApiState } from "../../selectors";
import Id from "../../utils/Id";

import "./style.scss";

const ExportTags = connect((state) => ({
    api: getApiState(state),
}))((props) => {
    const { segmentExport } = props;

    return (
        <span className="SegmentExport-tags">
            {!isEmpty(segmentExport.tags) && segmentExport.tags.map((item, index) => <Id value={item} key={index} />)}
        </span>
    );
});

export default ExportTags;
