import React from "react";
import { isEmpty } from "lodash";
import { useTranslation } from "react-i18next";
import Id from "../../utils/Id";

const GroupInfo = (props) => {
    const { segment } = props;

    const { t } = useTranslation("segments");

    return (
        !isEmpty(segment) && (
            <div className="SegmentInfo">
                <div className="SegmentInfo-name">{segment.name}</div>
                <div className="SegmentInfo-description">{t("card.groupHeader")}</div>

                <div className="GroupIds">
                    <span className="GroupIds-label">ID</span>
                    <span>
                        <Id value={segment.id} copyable={true} />
                    </span>
                </div>
            </div>
        )
    );
};

export default React.memo(GroupInfo);
