import React, { useState } from "react";
import FontAwesome from "react-fontawesome";
import { Button } from "@lib/components/lego";
import AddUserPopup from "./AddUserPopup";
import SegmentUsersList from "./SegmentUsersList";

import "./style.scss";

const SegmentUser = (props) => {
    const { users, allowedToEdit, addUserFunc, removeUserFunc, actionLabel, removeActionLabel } = props;

    const [collapsed, setCollapsed] = useState(true);
    const [addPopupVisible, setAddPopupVisible] = useState(false);

    const handleShowDialog = () => {
        setCollapsed(false);
        setAddPopupVisible(!addPopupVisible);
    };

    return (
        <div>
            <SegmentUsersList
                users={users}
                collapsed={collapsed}
                onExpandClick={() => setCollapsed(!collapsed)}
                removeUserFunc={removeUserFunc}
                canRemove={allowedToEdit}
                remoeActionLabel={removeActionLabel}
            />

            {allowedToEdit && (
                <div className="SegmentUser-add-button">
                    <Button view="default" size="s" onClick={handleShowDialog}>
                        <FontAwesome name="plus" />
                        <span className="small-screen-icon">
                            {" "}
                            <FontAwesome name="user" />
                        </span>
                        <span className="normal-screen-icon">{" " + actionLabel}</span>
                    </Button>

                    <AddUserPopup
                        visible={addPopupVisible}
                        addUserFunc={addUserFunc}
                        actionName={actionLabel}
                        onOutsideClick={() => setAddPopupVisible(!addPopupVisible)}
                    />
                </div>
            )}
        </div>
    );
};

export default SegmentUser;
